PlayerEvents.tick((event) => {
  const { player, level } = event;
  if (player.age % 80 == 0) {
    let pos = player.blockPosition();
    let kuLevel = new Ku.Level(level);

    // only check if player is at location
    const isThere = kuLevel.isStructureAtLocation(
      pos,
      "castle_in_the_sky:castle_in_the_sky"
    );
    if (!isThere) return;

    let structures = kuLevel.getStructuresAtLocation(pos);
    let castle = structures[0]; // assuming only the castle structure spawns here

    let structureManager = level.structureManager();
    let structureStart = structureManager.getStructureAt(pos, castle);
    let boundingBox = structureStart.getBoundingBox();

    let core = level.getBlock(
      boundingBox.minX() + 75,
      boundingBox.minY() + 15,
      boundingBox.minZ() + 73
    );
    if (core.id != "castle_in_the_sky:laputa_core") return;

    if (core.properties["powered"] == "true") {
      player.potionEffects.add(
        "castle_in_the_sky:sacred_castle_effect",
        90,
        0,
        true,
        false
      );
    }
  }
});

const spellBook = Java.loadClass(
  "com.hollingsworth.arsnouveau.common.items.SpellBook"
);

const spellBooks = [
  "ars_nouveau:novice_spell_book",
  "ars_nouveau:apprentice_spell_book",
  "ars_nouveau:archmage_spell_book",
  "ars_nouveau:creative_spell_book",
];
const blacklistedGlyphs = [
  "ars_nouveau:glyph_dispel",
  "ars_nouveau:glyph_break",
];

ItemEvents.rightClicked(spellBooks, (event) => {
  const { player, item } = event;
  if (!player.potionEffects.isActive("castle_in_the_sky:sacred_castle_effect"))
    return;

  let book = spellBook.BookCaster(item);
  let spell = book.spell;
  if (spell == null) return;

  let glyphs = spell.recipe;
  glyphs.forEach((glyph) => {
    let glyphName = glyph.registryName;
    if (blacklistedGlyphs.includes(glyphName.toString())) {
      message(event, "You are not allowed to use this spell here.");
      event.cancel();
    }
  });
});

BlockEvents.broken((event) => {
  const { player, block } = event;
  if (player.potionEffects.isActive("castle_in_the_sky:sacred_castle_effect")) {
    message(
      event,
      "The forces of the Sky Castle are too strong to break through."
    );
    event.cancel();
  }
});
const itemsBlacklist = [
  "travelanchors:travel_staff",
  "minecraft:chorus_fruit",
  "cyclic:chorus_flight",
  "cyclic:chorus_spectral",
];
ItemEvents.rightClicked(itemsBlacklist, (event) => {
  if (
    event.player.potionEffects.isActive(
      "castle_in_the_sky:sacred_castle_effect"
    )
  ) {
    message(event, "You are not allowed to use this item here.");
    event.cancel();
  }
});
ItemEvents.rightClicked("minecraft:milk_bucket", (event) => {
  const { player, item } = event;
  if (player.potionEffects.isActive("castle_in_the_sky:sacred_castle_effect")) {
    player.potionEffects.add("minecraft:wither", 200, 0, true, false);
    player.potionEffects.add("minecraft:nausea", 200, 0, true, false);
    player.potionEffects.add("minecraft:blindness", 200, 0, true, false);
    message(event, "I shouldn't have drank that...");
    item.count--;
    player.giveInHand("minecraft:bucket");
    event.cancel();
  }
});
