/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import mekanism.common.lib.WildcardMatcher;
import mekanism.common.util.MekanismUtils;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.items.ItemHandlerHelper;

public interface Finder {
    public static final Finder ANY = stack -> true;

    public static Finder item(Item itemType) {
        return stack -> itemType != Items.f_41852_ && itemType == stack.m_41720_();
    }

    public static Finder item(ItemStack itemType) {
        return stack -> ItemStack.m_41746_((ItemStack)itemType, (ItemStack)stack);
    }

    public static Finder strict(ItemStack itemType) {
        return stack -> ItemHandlerHelper.canItemStacksStack((ItemStack)itemType, (ItemStack)stack);
    }

    public static Finder tag(String tagName) {
        return stack -> !stack.m_41619_() && stack.m_204131_().anyMatch(tag -> WildcardMatcher.matches(tagName, tag));
    }

    public static Finder modID(String modID) {
        return stack -> !stack.m_41619_() && WildcardMatcher.matches(modID, MekanismUtils.getModId(stack));
    }

    public static Finder material(Material materialType) {
        return stack -> {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem)) {
                return false;
            }
            return Block.m_49814_((Item)stack.m_41720_()).m_49966_().m_60767_() == materialType;
        };
    }

    public boolean modifies(ItemStack var1);
}

