/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.ElectrolysisIRecipe;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.Separating")
public class ElectrolysisRecipeManager
extends MekanismRecipeManager<ElectrolysisRecipe> {
    public static final ElectrolysisRecipeManager INSTANCE = new ElectrolysisRecipeManager();

    private ElectrolysisRecipeManager() {
        super(MekanismRecipeType.SEPARATING);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput, FloatingLong energyMultiplier) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, leftGasOutput, rightGasOutput, energyMultiplier));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, FluidStackIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, leftGasOutput, rightGasOutput, FloatingLong.ONE));
    }

    public final ElectrolysisRecipe makeRecipe(ResourceLocation id, FluidStackIngredient input, ICrTChemicalStack.ICrTGasStack leftGasOutput, ICrTChemicalStack.ICrTGasStack rightGasOutput, FloatingLong energyMultiplier) {
        if (energyMultiplier.smallerThan(FloatingLong.ONE)) {
            throw new IllegalArgumentException("Energy multiplier must be at least one! Multiplier: " + energyMultiplier);
        }
        return new ElectrolysisIRecipe(id, input, energyMultiplier.copyAsConst(), this.getAndValidateNotEmpty(leftGasOutput), this.getAndValidateNotEmpty(rightGasOutput));
    }

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ElectrolysisRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return CrTUtils.describeOutputs(((ElectrolysisRecipe)this.recipe).getOutputDefinition(), output -> new CrTChemicalStack.CrTGasStack(output.left()) + " and " + new CrTChemicalStack.CrTGasStack(output.right()));
            }
        };
    }
}

