/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.client.CachedEdge;
import dev.ftb.mods.ftbultimine.client.UltimineRenderTypes;
import dev.ftb.mods.ftbultimine.config.FTBUltimineClientConfig;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.event.LevelRenderLastEvent;
import dev.ftb.mods.ftbultimine.net.KeyPressedPacket;
import dev.ftb.mods.ftbultimine.net.ModeChangedPacket;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.utils.ShapeMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FTBUltimineClient
extends FTBUltimineCommon {
    public static KeyMapping keyBinding;
    private boolean pressed;
    private boolean canUltimine;
    private List<BlockPos> shapeBlocks = Collections.emptyList();
    private int actualBlocks = 0;
    private List<CachedEdge> cachedEdges = null;
    private BlockPos cachedPos = null;
    public boolean hasScrolled = false;
    private long lastToggle = 0L;
    public final int INPUT_DELAY = 125;
    private int shapeIdx = 0;
    private final int infoOffset = 0;

    public FTBUltimineClient() {
        keyBinding = new KeyMapping("key.ftbultimine", InputConstants.Type.KEYSYM, 96, "key.categories.ftbultimine");
        KeyMappingRegistry.register((KeyMapping)keyBinding);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(__ -> FTBUltimineClientConfig.load());
        ClientLifecycleEvent.CLIENT_SETUP.register(this::onClientSetup);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        ClientGuiEvent.RENDER_HUD.register(this::renderGameOverlay);
        LevelRenderLastEvent.EVENT.register(this::renderInGame);
        ClientRawInputEvent.MOUSE_SCROLLED.register(this::mouseEvent);
        ClientRawInputEvent.KEY_PRESSED.register(this::onKeyPress);
    }

    private void onClientSetup(Minecraft minecraft) {
        ShapeRegistry.freeze();
    }

    @Override
    public void setShape(int shapeIdx, List<BlockPos> blocks) {
        this.shapeIdx = shapeIdx;
        this.actualBlocks = blocks.size();
        int maxRendered = Math.min(this.actualBlocks, (Integer)FTBUltimineClientConfig.renderOutline.get());
        this.shapeBlocks = blocks.subList(0, maxRendered);
        this.cachedEdges = null;
        this.updateEdges();
    }

    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public void editConfig(boolean isClientConfig) {
        if (isClientConfig) {
            new EditConfigScreen(FTBUltimineClientConfig.getConfigGroup()).openGui();
        } else {
            new EditConfigScreen(FTBUltimineServerConfig.getConfigGroup()).openGui();
        }
    }

    public void renderInGame(PoseStack stack) {
        if (!this.pressed || this.cachedPos == null || this.cachedEdges == null || this.cachedEdges.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (!this.canUltimine) {
            return;
        }
        Camera activeRenderInfo = mc.m_91290_().f_114358_;
        Vec3 projectedView = activeRenderInfo.m_90583_();
        stack.m_85836_();
        stack.m_85837_((double)this.cachedPos.m_123341_() - projectedView.f_82479_, (double)this.cachedPos.m_123342_() - projectedView.f_82480_, (double)this.cachedPos.m_123343_() - projectedView.f_82481_);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_(UltimineRenderTypes.LINES_NORMAL);
        for (CachedEdge edge : this.cachedEdges) {
            buffer.m_85982_(matrix, edge.x1, edge.y1, edge.z1).m_6122_(255, 255, 255, 255).m_5752_();
            buffer.m_85982_(matrix, edge.x2, edge.y2, edge.z2).m_6122_(255, 255, 255, 255).m_5752_();
        }
        mc.m_91269_().m_110104_().m_109912_(UltimineRenderTypes.LINES_NORMAL);
        VertexConsumer buffer2 = mc.m_91269_().m_110104_().m_6299_(UltimineRenderTypes.LINES_TRANSPARENT);
        for (CachedEdge edge : this.cachedEdges) {
            buffer2.m_85982_(matrix, edge.x1, edge.y1, edge.z1).m_6122_(255, 255, 255, 10).m_5752_();
            buffer2.m_85982_(matrix, edge.x2, edge.y2, edge.z2).m_6122_(255, 255, 255, 10).m_5752_();
        }
        mc.m_91269_().m_110104_().m_109912_(UltimineRenderTypes.LINES_TRANSPARENT);
        stack.m_85849_();
    }

    public EventResult mouseEvent(Minecraft client, double amount) {
        if (this.pressed && amount != 0.0 && this.sneak()) {
            this.hasScrolled = true;
            new ModeChangedPacket(amount < 0.0).sendToServer();
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult onKeyPress(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (System.currentTimeMillis() - this.lastToggle < 125L) {
            return EventResult.pass();
        }
        if (keyCode != 265 && keyCode != 264) {
            return EventResult.pass();
        }
        if (!this.pressed || !this.sneak()) {
            return EventResult.pass();
        }
        this.hasScrolled = true;
        new ModeChangedPacket(keyCode == 264).sendToServer();
        this.lastToggle = System.currentTimeMillis();
        return EventResult.pass();
    }

    private boolean sneak() {
        if (!((Boolean)FTBUltimineClientConfig.requireSneakForMenu.get()).booleanValue()) {
            return true;
        }
        return FTBUltimineClient.keyBinding.f_90816_.m_84873_() == 340 || FTBUltimineClient.keyBinding.f_90816_.m_84873_() == 344 ? Screen.m_96637_() : Screen.m_96638_();
    }

    private void addPressedInfo(List<MutableComponent> list) {
        MutableComponent msg = CooldownTracker.isOnCooldown(FTBUltimineClient.getClientPlayer()) ? Component.m_237115_((String)"ftbultimine.info.cooldown").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)12566412))) : (this.canUltimine && this.actualBlocks > 0 ? Component.m_237115_((String)"ftbultimine.info.active").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)10731148))) : Component.m_237115_((String)"ftbultimine.info.not_active").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)12542314))));
        list.add(Component.m_237110_((String)"ftbultimine.info.base", (Object[])new Object[]{msg}));
        if (!this.hasScrolled) {
            MutableComponent msg1 = Component.m_237115_((String)((Boolean)FTBUltimineClientConfig.requireSneakForMenu.get() != false ? "ftbultimine.change_shape" : "ftbultimine.change_shape.no_shift")).m_130940_(ChatFormatting.GRAY);
            list.add(msg1);
        }
        int context = Math.min((ShapeRegistry.shapeCount() - 1) / 2, (Integer)FTBUltimineClientConfig.shapeMenuContextLines.get());
        if (this.sneak()) {
            list.add(Component.m_237113_((String)""));
            for (int i = -context; i < 0; ++i) {
                String prefix = i == -context ? "^ " : " | ";
                list.add(Component.m_237113_((String)prefix).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("ftbultimine.shape." + ShapeRegistry.getShape(this.shapeIdx + i).getName()))));
            }
        }
        MutableComponent mining = Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237115_((String)("ftbultimine.shape." + ShapeRegistry.getShape(this.shapeIdx).getName())));
        if (this.canUltimine && this.actualBlocks != 0) {
            mining.m_130946_(" (").m_7220_((Component)Component.m_237110_((String)"ftbultimine.info.blocks", (Object[])new Object[]{this.actualBlocks}));
            if (this.actualBlocks > this.shapeBlocks.size()) {
                mining.m_130946_(", ").m_7220_((Component)Component.m_237110_((String)"ftbultimine.info.partial_render", (Object[])new Object[]{this.shapeBlocks.size()}));
            }
            mining.m_130946_(")");
        }
        list.add(mining);
        if (this.sneak()) {
            for (int i = 1; i <= context; ++i) {
                String prefix = i == context ? "v " : " | ";
                list.add(Component.m_237113_((String)prefix).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("ftbultimine.shape." + ShapeRegistry.getShape(this.shapeIdx + i).getName()))));
            }
        }
    }

    public void renderGameOverlay(PoseStack matrices, float tickDelta) {
        if (this.pressed) {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            this.addPressedInfo(list);
            Minecraft minecraft = Minecraft.m_91087_();
            Objects.requireNonNull(minecraft.f_91062_);
            int top = 2 + 9 * 0;
            boolean first = true;
            for (MutableComponent msg : list) {
                FormattedCharSequence formatted = msg.m_7532_();
                if (first) {
                    float f = CooldownTracker.getCooldownRemaining(FTBUltimineClient.getClientPlayer());
                    if (f < 1.0f) {
                        int n = 2 + (int)((float)minecraft.f_91062_.m_92724_(formatted) * f) + 1;
                        Objects.requireNonNull(minecraft.f_91062_);
                        GuiComponent.m_93172_((PoseStack)matrices, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1439812544);
                    } else {
                        int n = 2 + minecraft.f_91062_.m_92724_(formatted) + 1;
                        Objects.requireNonNull(minecraft.f_91062_);
                        GuiComponent.m_93172_((PoseStack)matrices, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1439812544);
                    }
                } else {
                    int n = 2 + minecraft.f_91062_.m_92724_(formatted) + 1;
                    Objects.requireNonNull(minecraft.f_91062_);
                    GuiComponent.m_93172_((PoseStack)matrices, (int)1, (int)(top - 1), (int)n, (int)(top + 9 - 1), (int)-1439812544);
                }
                GuiComponent.m_168756_((PoseStack)matrices, (Font)minecraft.f_91062_, (FormattedCharSequence)formatted, (int)2, (int)top, (int)15527924);
                Objects.requireNonNull(minecraft.f_91062_);
                top += 9;
                first = false;
            }
        }
    }

    public void clientTick(Minecraft mc) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        boolean p = this.pressed;
        this.pressed = keyBinding.m_90857_();
        if (this.pressed != p) {
            new KeyPressedPacket(this.pressed).sendToServer();
        }
        this.canUltimine = this.pressed && FTBUltimine.instance.canUltimine((Player)mc.f_91074_);
    }

    private void updateEdges() {
        if (this.cachedEdges != null) {
            return;
        }
        if (this.shapeBlocks.isEmpty()) {
            this.cachedEdges = Collections.emptyList();
            return;
        }
        this.cachedPos = this.shapeBlocks.get(0);
        double d = 0.005;
        this.cachedEdges = new ArrayList<CachedEdge>();
        HashSet<VoxelShape> shapes = new HashSet<VoxelShape>();
        for (AABB aabb : ShapeMerger.merge(this.shapeBlocks, this.cachedPos)) {
            shapes.add(Shapes.m_83064_((AABB)aabb.m_82400_(d)));
        }
        FTBUltimineClient.orShapes(shapes).m_83224_((x1, y1, z1, x2, y2, z2) -> {
            CachedEdge edge = new CachedEdge();
            edge.x1 = (float)x1;
            edge.y1 = (float)y1;
            edge.z1 = (float)z1;
            edge.x2 = (float)x2;
            edge.y2 = (float)y2;
            edge.z2 = (float)z2;
            this.cachedEdges.add(edge);
        });
    }

    static VoxelShape orShapes(Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            combinedShape = Shapes.m_83148_((VoxelShape)combinedShape, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return combinedShape;
    }
}

