/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.OptionalInt;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.rocketplatform.game.client.mod.util.SingleKeyCache;

public class MultilineStringWidget
extends Widget {
    private final Component message;
    private final boolean shadow;
    private OptionalInt maxWidth;
    private OptionalInt maxRows;
    private final SingleKeyCache<CacheKey, MultiLineLabel> cache;
    private boolean centered;

    public MultilineStringWidget(Panel panel, Component message) {
        this(panel, message, true);
    }

    public MultilineStringWidget(Panel panel, Component message, boolean shadow) {
        super(panel);
        this.message = message;
        this.shadow = shadow;
        this.maxWidth = OptionalInt.empty();
        this.maxRows = OptionalInt.empty();
        this.centered = false;
        this.cache = new SingleKeyCache<CacheKey, MultiLineLabel>(key -> key.maxRows.isPresent() ? MultiLineLabel.m_94345_((Font)Theme.DEFAULT.getFont(), (FormattedText)key.message, (int)key.maxWidth, (int)key.maxRows.getAsInt()) : MultiLineLabel.m_94341_((Font)Theme.DEFAULT.getFont(), (FormattedText)key.message, (int)key.maxWidth));
    }

    public MultilineStringWidget setMaxWidth(int maxWidth) {
        this.maxWidth = OptionalInt.of(maxWidth);
        return this;
    }

    public MultilineStringWidget setMaxRows(int maxRows) {
        this.maxRows = OptionalInt.of(maxRows);
        return this;
    }

    public MultilineStringWidget setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    private CacheKey getFreshCacheKey() {
        return new CacheKey(this.message, this.maxWidth.orElse(Integer.MAX_VALUE), this.maxRows);
    }

    public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        MultiLineLabel multiLineLabel = this.cache.getValue(this.getFreshCacheKey());
        int xPos = this.getX();
        int yPos = this.getY();
        int lineHeight = 9;
        int color = 0xFFFFFF;
        if (this.centered) {
            multiLineLabel.m_6514_(graphics, xPos + this.width / 2, yPos, lineHeight, color);
        } else if (this.shadow) {
            multiLineLabel.m_6516_(graphics, xPos, yPos, lineHeight, color);
        } else {
            multiLineLabel.m_6508_(graphics, xPos, yPos, lineHeight, color);
        }
    }

    public record CacheKey(Component message, int maxWidth, OptionalInt maxRows) {
    }
}

