/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.variable;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;

public class VariableProcessor {
    public static String process(String input, VariableStorage storage) {
        for (Map.Entry<String, Object> entry : storage.getContents().entrySet()) {
            if (entry.getValue() == null) {
                RocketClientMod.getLogger().debug("Variable {} was not specified. Not storing anything.", (Object)entry.getKey());
                continue;
            }
            input = input.replace("$" + entry.getKey(), entry.getValue().toString());
        }
        return input;
    }

    public static Component processComponent(Component input, VariableStorage storage) {
        MutableComponent result;
        ComponentContents componentContents = input.m_214077_();
        if (componentContents instanceof LiteralContents) {
            LiteralContents contents = (LiteralContents)componentContents;
            result = Component.m_237113_((String)VariableProcessor.process(contents.f_237368_(), storage)).m_6270_(input.m_7383_());
        } else {
            componentContents = input.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)componentContents;
                Object[] args = new Object[contents.m_237523_().length];
                for (int i = 0; i < args.length; ++i) {
                    Object oldArg = contents.m_237523_()[i];
                    if (oldArg instanceof Component) {
                        Component component = (Component)oldArg;
                        args[i] = VariableProcessor.processComponent(component, storage);
                        continue;
                    }
                    if (oldArg instanceof String) {
                        String str = (String)oldArg;
                        args[i] = VariableProcessor.process(str, storage);
                        continue;
                    }
                    args[i] = oldArg;
                }
                result = Component.m_237110_((String)contents.m_237508_(), (Object[])args).m_6270_(input.m_7383_());
            } else {
                return input;
            }
        }
        for (Component sibling : input.m_7360_()) {
            result.m_7220_(VariableProcessor.processComponent(sibling, storage));
        }
        return result;
    }
}

