/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.Vector2i;

public class PanelTemplate
extends WidgetElementTemplate {
    private static final Color4I LIST_COLOR = Color4I.rgba((int)74, (int)74, (int)74, (int)127);
    public static Theme SCROLLBAR_THEME = new Theme(){
        private static final Color4I SCROLLBAR_PRIMARY = Color4I.rgb((int)-8355712);
        private static final Color4I SCROLLBAR_SECONDARY = Color4I.rgb((int)-4144960);

        public void drawScrollBarBackground(PoseStack graphics, int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.draw(graphics, x, y, w, h);
        }

        public void drawScrollBar(PoseStack graphics, int x, int y, int w, int h, WidgetType type, boolean vertical) {
            SCROLLBAR_PRIMARY.draw(graphics, x, y, w, h);
            SCROLLBAR_SECONDARY.draw(graphics, x, y, w - 1, h - 1);
        }
    };
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final String WIDTH_PADDING_KEY = "width_padding";
    private static final String HEIGHT_PADDING_KEY = "height_padding";
    private static final String WIDTH_OFFSET_KEY = "width_offset";
    private static final String HEIGHT_OFFSET_KEY = "height_offset";
    private static final int DEFAULT_WIDTH = 128;
    private static final int DEFAULT_HEIGHT = 128;
    private List<ElementTemplate<?>> elements;
    private boolean scroll;
    @SerializedName(value="render_background")
    private boolean renderBackground;
    @SerializedName(value="render_type")
    private String renderType;
    @SerializedName(value="end_position")
    private ElementTemplate.Position endPosition;
    @SerializedName(value="hover_border")
    private boolean hoverBorder;

    public PanelTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public PanelTemplate(String type, String id, ElementTemplate.Position position, ElementCallback elementCallback, List<ElementTemplate<?>> elements) {
        super(type, id, position, elementCallback);
        this.elements = elements;
    }

    public Integer getWidth() {
        Number width = (Number)this.getOption(WIDTH_KEY);
        return width == null ? null : Integer.valueOf(width.intValue());
    }

    public Integer getHeight() {
        Number height = (Number)this.getOption(HEIGHT_KEY);
        return height == null ? null : Integer.valueOf(height.intValue());
    }

    public int getWidthPadding() {
        return this.getOption(WIDTH_PADDING_KEY, 0);
    }

    public int getHeightPadding() {
        return this.getOption(HEIGHT_PADDING_KEY, 0);
    }

    public int getWidthOffset() {
        return this.getOption(WIDTH_OFFSET_KEY, 0);
    }

    public int getHeightOffset() {
        return this.getOption(HEIGHT_OFFSET_KEY, 0);
    }

    public Integer getEndX() {
        if (this.endPosition == null) {
            throw new IllegalArgumentException("End position is required for DividerTemplate if width is not specified");
        }
        return this.endPosition.x();
    }

    public Integer getEndY() {
        if (this.endPosition == null) {
            throw new IllegalArgumentException("End position is required for DividerTemplate if height is not specified");
        }
        return this.endPosition.y();
    }

    @Override
    public Widget createElement0(final TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, final VariableStorage variableStorage) {
        final int widgetWidth = Objects.requireNonNullElseGet(this.getWidth(), () -> screen.getWidth() - this.getEndX() - this.getPosition().x());
        final int widgetHeight = Objects.requireNonNullElseGet(this.getHeight(), () -> screen.getHeight() - this.getEndY() - this.getPosition().y());
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, widgetWidth, widgetHeight);
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        final AtomicReference<3> scrollBarRef = new AtomicReference<3>();
        final int widthPadding = this.getWidthPadding();
        final int heightPadding = this.getHeightPadding();
        Panel panel = new Panel(screen.getPanel()){

            public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                if (PanelTemplate.this.hoverBorder && this.getWidgetType() == WidgetType.MOUSE_OVER) {
                    GuiHelper.setupDrawing();
                    Color4I.WHITE.draw(graphics, x - 1, y - 1, w + 2, 1);
                    Color4I.WHITE.draw(graphics, x - 1, y - 1, 1, h + 2);
                    Color4I.WHITE.draw(graphics, x + w, y - 1, 1, h + 2);
                    Color4I.WHITE.draw(graphics, x - 1, y + h, w + 2, 1);
                }
                super.draw(graphics, theme, x, y, w, h);
            }

            public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                if (PanelTemplate.this.renderBackground) {
                    RenderType renderType;
                    int widthOffset = PanelTemplate.this.getWidthOffset();
                    int heightOffset = PanelTemplate.this.getHeightOffset();
                    RenderType renderType2 = renderType = PanelTemplate.this.renderType == null ? null : RenderType.valueOf(PanelTemplate.this.renderType.toUpperCase(Locale.ROOT));
                    if (renderType == null) {
                        theme.drawGui(graphics, x + widthOffset - 3, y + heightOffset - 3, w + 6, h + 6, WidgetType.NORMAL);
                    } else {
                        switch (renderType) {
                            case SLOT: {
                                theme.drawSlot(graphics, x + widthOffset, y + heightOffset, w, h, WidgetType.NORMAL);
                                break;
                            }
                            case LIST: {
                                LIST_COLOR.draw(graphics, x + widthOffset, y + heightOffset, w, h);
                                break;
                            }
                            case BUTTON: {
                                theme.drawButton(graphics, x + widthOffset, y + heightOffset, w, h, WidgetType.NORMAL);
                                break;
                            }
                            default: {
                                theme.drawWidget(graphics, x + widthOffset, y + heightOffset, w, h, WidgetType.NORMAL);
                            }
                        }
                    }
                }
                super.drawBackground(graphics, theme, x, y, w, h);
            }

            public void addWidgets() {
                PanelTemplate.this.addWidgets(screen, this, variableStorage, widgetWidth, widgetHeight);
            }

            public void alignWidgets() {
                PanelScrollBar scrollBar = (PanelScrollBar)scrollBarRef.get();
                if (scrollBar != null) {
                    scrollBar.setPosAndSize(this.posX + this.width, this.posY, 6, this.height);
                }
            }

            public boolean mouseScrolled(double scroll) {
                return scrollBarRef.get() != null ? ((PanelScrollBar)scrollBarRef.get()).mouseScrolled(scroll) : super.mouseScrolled(scroll);
            }

            public boolean mousePressed(MouseButton button) {
                if (this.isMouseOver()) {
                    if (this.getWidgetType() != WidgetType.DISABLED) {
                        PanelTemplate.this.runCallbacks(screen);
                    }
                    return super.mousePressed(button);
                }
                return super.mousePressed(button);
            }

            public int getContentWidth() {
                return super.getContentWidth() + widthPadding;
            }

            public int getContentHeight() {
                return super.getContentHeight() + heightPadding;
            }
        };
        if (this.scroll) {
            PanelScrollBar scrollBar = new PanelScrollBar(screen.getPanel(), panel){

                public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                    super.draw(graphics, SCROLLBAR_THEME, x, y, w, h);
                }

                public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                    if (this.getScrollBarSize() <= 0) {
                        return;
                    }
                    super.drawBackground(graphics, theme, x, y, w, h);
                }

                public double getMaxValue() {
                    return this.plane.isVertical ? (double)(this.panel.getContentHeight() - this.panel.height) : (double)(this.panel.getContentWidth() - this.panel.width);
                }

                public void setMaxValue(double max) {
                    throw new UnsupportedOperationException("attempt to set max value of panel scrollbar");
                }

                public boolean shouldDraw() {
                    return this.getScrollBarSize() > 0;
                }

                public boolean isEnabled() {
                    return this.getScrollBarSize() > 0;
                }
            };
            scrollBar.setCanAlwaysScroll(true);
            scrollBar.setScrollStep(20.0);
            scrollBar.setPosAndSize(panel.posX + panel.width, panel.posY, 6, panel.height);
            scrollBarRef.set(scrollBar);
            screen.getPanel().add((Widget)scrollBar);
        }
        panel.setPosAndSize(pos.x(), pos.y(), widgetWidth, widgetHeight);
        return panel;
    }

    protected void addWidgets(TemplateScreen parentScreen, Panel panel, VariableStorage variableStorage, int width, int height) {
        for (ElementTemplate<?> element : this.elements) {
            if (!(element instanceof WidgetElementTemplate)) continue;
            WidgetElementTemplate ftbElement = (WidgetElementTemplate)element;
            TemplateScreen templateScreen = TemplateScreen.wrap(panel);
            templateScreen.getStorage().inherit(parentScreen.getStorage(), false);
            templateScreen.getStorage().inherit(variableStorage, false);
            panel.add((Widget)ftbElement.createElement(templateScreen, width, height, 0, 0, templateScreen.getStorage()));
        }
    }

    static enum RenderType {
        WIDGET,
        SLOT,
        LIST,
        BUTTON;

    }
}

