/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class OpenScreenCallback
extends ElementCallback {
    private static final Map<String, Supplier<Screen>> BUILTIN_SCREENS = Map.of("title", TitleScreen::new, "pause", () -> new PauseScreen(true));
    private String id;
    @SerializedName(value="pass_storage")
    private boolean passStorage;

    public OpenScreenCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        try {
            String id = VariableProcessor.process(this.id, variableStorage);
            Supplier<Screen> screenSupplier = BUILTIN_SCREENS.get(id);
            if (screenSupplier != null) {
                screen.getMinecraft().m_91152_(screenSupplier.get());
                return;
            }
            LayoutTemplate layout = RocketClientMod.getInstance().getLayoutRepository().getLayout(id);
            if (layout == null) {
                throw new IllegalStateException("Cannot find layout with id " + id);
            }
            Screen newScreen = layout.createScreen(this.passStorage ? variableStorage : null);
            screen.getMinecraft().m_91152_(newScreen);
        }
        catch (Throwable t) {
            this.onError(holder, new RuntimeException("An error occurred opening screen while processing callback", t));
        }
    }
}

