/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.client.RocketRequests;
import net.rocketplatform.game.client.mod.ui.MultilineErrorScreen;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class DownloadWorldCallback
extends ElementCallback {
    @SerializedName(value="loading_screen")
    private LayoutTemplate loadingScreen;
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public DownloadWorldCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        Screen currentScreen;
        if (!variableStorage.contains("gameServerId")) {
            this.handleFailure("Unable to download world: Could not find game server id.", null, null, new Throwable());
            return;
        }
        String gameServerId = (String)variableStorage.retrieve("gameServerId");
        if (!variableStorage.contains("selectedWorldId")) {
            this.handleFailure("Unable to download world: A world was not selected.", gameServerId, null, new Throwable());
            return;
        }
        int worldId = (Integer)variableStorage.retrieve("selectedWorldId");
        Screen screen2 = currentScreen = this.loadingScreen == null ? null : screen.getMinecraft().f_91080_;
        if (this.loadingScreen != null) {
            Screen loadingScreen = this.loadingScreen.createScreen(variableStorage);
            screen.getMinecraft().m_91152_(loadingScreen);
        }
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenApply(client -> client.executeSubscription(RocketRequests.DOWNLOAD_WORLD, Map.of("gameServerId", gameServerId, "worldId", worldId)))).whenComplete((subscription, e) -> {
            if (e != null) {
                this.handleFailure("Failed to download world: " + e.getMessage(), gameServerId, worldId, (Throwable)e);
                return;
            }
            subscription.subscribe(response -> {
                subscription.unsubscribe();
                String url = response.getUrl();
                try {
                    Util.m_137581_().m_137650_(URI.create(url).toURL());
                }
                catch (MalformedURLException ex) {
                    RocketClientMod.getLogger().error("Unable to download world: Failed to open world download URL. {}", (Object)url, (Object)ex);
                    return;
                }
                if (currentScreen != null) {
                    RenderSystem.m_69879_(() -> screen.getMinecraft().m_91152_(currentScreen));
                }
                if (this.onComplete != null) {
                    RenderSystem.m_69879_(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
                }
            });
        });
    }

    private void handleFailure(String reason, @Nullable String gameServerId, @Nullable Integer worldId, Throwable exception) {
        RocketClientMod.getLogger().error("An error occurred (gameServerId: {}, worldId: {}): {}", new Object[]{gameServerId, worldId, reason, exception});
        RenderSystem.m_69879_(() -> {
            MultilineErrorScreen errorScreen = new MultilineErrorScreen((Component)Component.m_237115_((String)"rgp_client.gui.button.ftb_worlds"), (Component)Component.m_237113_((String)reason));
            Minecraft.m_91087_().m_91152_((Screen)errorScreen);
        });
    }
}

