/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import com.google.gson.annotations.SerializedName;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.rocketplatform.client.generated.InvitedPlayer;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class PlayerListEntryLoader
extends ListEntryLoader {
    @SerializedName(value="pending_entry_template")
    private AbstractListLayoutTemplate.ListEntry pendingEntryTemplate;

    public PlayerListEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        if (storage == null) {
            RocketClientMod.getLogger().warn("No storage provided for player list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        if (!storage.contains("gameServerId")) {
            RocketClientMod.getLogger().warn("No game server ID provided for player list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        String gameServerId = (String)storage.retrieve("gameServerId");
        return ((CompletableFuture)((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getInvitedPlayers(gameServerId))).thenApply(playerList -> {
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            List<InvitedPlayer> players = playerList.getPlayers().stream().sorted(Comparator.comparing(InvitedPlayer::getApproved)).toList();
            for (InvitedPlayer player : players) {
                GameProfile incompleteProfile = new GameProfile(UUID.fromString(player.getPlayerId()), null);
                incompleteProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(incompleteProfile, false);
                VariableStorage playerStorage = new VariableStorage();
                playerStorage.store("playerName", incompleteProfile.getName() == null ? "Unknown" : incompleteProfile.getName());
                playerStorage.store("playerId", player.getPlayerId());
                playerStorage.store("approved", player.getApproved());
                List<ElementTemplate<?>> elements = player.getApproved() != false ? PlayerListEntryLoader.processElements(entryTemplate, playerStorage) : PlayerListEntryLoader.processElements(this.pendingEntryTemplate, playerStorage);
                AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), playerStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                entries.add(new ListEntryLoader.ListEntryTemplate(entry, playerStorage));
            }
            return entries;
        })).exceptionally(e -> {
            RocketClientMod.getLogger().error("Failed to load player entries", e);
            return List.of();
        });
    }
}

