/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.keypair;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import net.rocketplatform.game.client.mod.keypair.CryptUtil;

public record ProfilePublicKey(Data data) {
    public static final Codec<ProfilePublicKey> TRUSTED_CODEC = Data.CODEC.xmap(ProfilePublicKey::new, ProfilePublicKey::data);

    public record Data(Instant expiresAt, PublicKey key, byte[] keySignature) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CryptUtil.INSTANT_ISO8601_CODEC.fieldOf("expires_at").forGetter(Data::expiresAt), (App)CryptUtil.PUBLIC_KEY_CODEC.fieldOf("key").forGetter(Data::key), (App)CryptUtil.BASE64_STRING_CODEC.fieldOf("signature_v2").forGetter(Data::keySignature)).apply((Applicative)builder, Data::new));

        public boolean hasExpired() {
            return this.expiresAt.isBefore(Instant.now());
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Data)) {
                return false;
            }
            Data data = (Data)obj;
            return this.expiresAt.equals(data.expiresAt) && this.key.equals(data.key) && Arrays.equals(this.keySignature, data.keySignature);
        }
    }
}

