/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.keypair;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.function.Function;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;

public class CryptUtil {
    public static final Codec<Instant> INSTANT_ISO8601_CODEC = CryptUtil.temporalCodec(DateTimeFormatter.ISO_INSTANT).xmap(Instant::from, Function.identity());
    public static final Codec<byte[]> BASE64_STRING_CODEC = Codec.STRING.comapFlatMap(base64String -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)base64String));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error((String)"Malformed base64 string");
        }
    }, byteArray -> Base64.getEncoder().encodeToString((byte[])byteArray));
    public static final Base64.Encoder MIME_ENCODER = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
    public static final Codec<PublicKey> PUBLIC_KEY_CODEC = Codec.STRING.comapFlatMap(publicKeyString -> {
        try {
            return DataResult.success((Object)CryptUtil.stringToRsaPublicKey(publicKeyString));
        }
        catch (CryptException e) {
            return DataResult.error((String)e.getMessage());
        }
    }, CryptUtil::rsaPublicKeyToString);
    public static final Codec<PrivateKey> PRIVATE_KEY_CODEC = Codec.STRING.comapFlatMap(privateKeyString -> {
        try {
            return DataResult.success((Object)CryptUtil.stringToPemRsaPrivateKey(privateKeyString));
        }
        catch (CryptException e) {
            return DataResult.error((String)e.getMessage());
        }
    }, CryptUtil::pemRsaPrivateKeyToString);

    public static PrivateKey stringToPemRsaPrivateKey(String privateKeyString) throws CryptException {
        return CryptUtil.rsaStringToKey(privateKeyString, "-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----", CryptUtil::byteToPrivateKey);
    }

    public static PublicKey stringToRsaPublicKey(String publicKeyString) throws CryptException {
        return CryptUtil.rsaStringToKey(publicKeyString, "-----BEGIN RSA PUBLIC KEY-----", "-----END RSA PUBLIC KEY-----", Crypt::m_13600_);
    }

    public static String rsaPublicKeyToString(PublicKey publicKey) {
        if (!"RSA".equals(publicKey.getAlgorithm())) {
            throw new IllegalArgumentException("Public key must be RSA");
        }
        return "-----BEGIN RSA PUBLIC KEY-----\n" + MIME_ENCODER.encodeToString(publicKey.getEncoded()) + "\n-----END RSA PUBLIC KEY-----\n";
    }

    public static String pemRsaPrivateKeyToString(PrivateKey privateKey) {
        if (!"RSA".equals(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("Private key must be RSA");
        }
        return "-----BEGIN RSA PRIVATE KEY-----\n" + MIME_ENCODER.encodeToString(privateKey.getEncoded()) + "\n-----END RSA PRIVATE KEY-----\n";
    }

    private static <T extends Key> T rsaStringToKey(String keyString, String keyBeginMarker, String keyEndMarker, ByteArrayToKeyFunction<T> keyConverter) throws CryptException {
        int startIndex = keyString.indexOf(keyBeginMarker);
        if (startIndex != -1) {
            int endIndex = keyString.indexOf(keyEndMarker, startIndex += keyBeginMarker.length());
            keyString = keyString.substring(startIndex, endIndex + 1);
        }
        try {
            return keyConverter.apply(Base64.getMimeDecoder().decode(keyString));
        }
        catch (IllegalArgumentException e) {
            throw new CryptException((Throwable)e);
        }
    }

    private static PrivateKey byteToPrivateKey(byte[] encodedKey) throws CryptException {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (Exception var3) {
            throw new CryptException((Throwable)var3);
        }
    }

    private static Codec<TemporalAccessor> temporalCodec(DateTimeFormatter formatter) {
        return Codec.STRING.comapFlatMap(from -> {
            try {
                return DataResult.success((Object)formatter.parse((CharSequence)from));
            }
            catch (Exception var3) {
                return DataResult.error((String)var3.getMessage());
            }
        }, formatter::format);
    }

    static interface ByteArrayToKeyFunction<T extends Key> {
        public T apply(byte[] var1) throws CryptException;
    }
}

