/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math.colors;

import java.util.Arrays;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.ColorSpaces;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.util.Mth;
import oshi.annotation.concurrent.Immutable;

@Immutable
public class HSVColor
extends BaseColor<HSVColor> {
    public HSVColor(float h, float s, float b, float a) {
        super(h, s, b, a);
    }

    public String toString() {
        return String.format("H: %s, S: %s, V %s", (int)(255.0f * this.hue()), (int)(255.0f * this.saturation()), (int)(255.0f * this.value()));
    }

    public float hue() {
        return this.v0;
    }

    public float saturation() {
        return this.v1;
    }

    public float value() {
        return this.v2;
    }

    public float alpha() {
        return this.v3;
    }

    public HSVColor withHue(float hue) {
        return new HSVColor(hue, this.saturation(), this.value(), this.alpha());
    }

    public HSVColor withSaturation(float saturation) {
        return new HSVColor(this.hue(), saturation, this.value(), this.alpha());
    }

    public HSVColor withValue(float value) {
        return new HSVColor(this.hue(), this.saturation(), value, this.alpha());
    }

    public HSVColor withAlpha(float alpha) {
        return new HSVColor(this.hue(), this.saturation(), this.value(), alpha);
    }

    @Override
    public HSVColor asHSV() {
        return this;
    }

    @Override
    public RGBColor asRGB() {
        return ColorSpaces.HSVtoRGB(this);
    }

    public static HSVColor averageColors(HSVColor ... colors) {
        float size = colors.length;
        Stream<Float> list = Arrays.stream(colors).map(HSVColor::hue);
        Float[] hues = (Float[])list.toArray(Float[]::new);
        float s = 0.0f;
        float v = 0.0f;
        float a = 0.0f;
        for (HSVColor c : colors) {
            s += c.saturation();
            v += c.value();
            a += c.alpha();
        }
        return new HSVColor(HSVColor.averageAngles(hues), s / size, v / size, a / size);
    }

    @Override
    public HSVColor multiply(HSVColor color, float hue, float saturation, float value, float alpha) {
        return new HSVColor(Mth.m_14036_((float)(hue * this.hue()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(saturation * this.saturation()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(value * this.value()), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(alpha * this.alpha()), (float)0.0f, (float)1.0f));
    }

    @Override
    public HSVColor mixWith(HSVColor color, float bias) {
        float h;
        float i = 1.0f - bias;
        for (h = HSVColor.weightedAverageAngles(this.hue(), color.hue(), bias); h < 0.0f; h += 1.0f) {
        }
        float s = this.saturation() * i + color.saturation() * bias;
        float v = this.value() * i + color.value() * bias;
        float a = this.alpha() * i + color.alpha() * bias;
        return new HSVColor(h, s, v, a);
    }

    @Override
    public HSVColor fromRGB(RGBColor rgb) {
        return rgb.asHSV();
    }

    @Override
    public float distTo(HSVColor other) {
        float h = this.hue();
        float h2 = other.hue();
        float c = this.saturation();
        float c2 = other.saturation();
        double x = (double)c * Math.cos((double)h * Math.PI * 2.0) - (double)c2 * Math.cos((double)h2 * Math.PI * 2.0);
        double y = (double)c * Math.sin((double)h * Math.PI * 2.0) - (double)c2 * Math.sin((double)h2 * Math.PI * 2.0);
        return (float)Math.sqrt(x * x + y * y + (double)((this.value() - other.value()) * (this.value() - other.value())));
    }
}

