/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.function.Consumer;
import me.ichun.mods.ichunutil.client.gui.bns.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.TextureDefinition;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ElementScrollBar<T extends ElementScrollBar>
extends Element<Fragment<?>> {
    public final Orientation orientation;
    private float scrollBarSize;
    public Consumer<T> callback;
    public float scrollProg;
    public boolean resizing;
    public Element.MousePos pos;

    public ElementScrollBar(@NotNull Fragment parent, Orientation orientation, float scrollBarSize) {
        super(parent);
        this.orientation = orientation;
        this.scrollBarSize = scrollBarSize;
    }

    public T setCallback(Consumer<T> callback) {
        this.callback = callback;
        return (T)this;
    }

    public void setScrollBarSize(float f) {
        f = Math.min(f, 1.01f);
        float oldSize = this.scrollBarSize;
        this.scrollBarSize = f;
        float size = (float)(this.orientation == Orientation.VERTICAL ? this.height : this.width) * f;
        if (size < 4.0f) {
            this.scrollBarSize = 4.0f / (float)this.getDistance();
        }
        this.updateSize(oldSize);
    }

    public float getScrollbarSize() {
        return this.scrollBarSize;
    }

    public void setScrollProg(float f) {
        float scroll = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        if (scroll != this.scrollProg) {
            this.scrollProg = scroll;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }

    private void updateSize(float oldSize) {
        if (this.scrollBarSize > 1.0f) {
            switch (this.orientation) {
                case VERTICAL: {
                    this.width = 0;
                    break;
                }
                case HORIZONTAL: {
                    this.height = 0;
                }
            }
            this.setScrollProg(0.0f);
        } else {
            this.setScrollProg(this.scrollProg / oldSize * this.scrollBarSize);
        }
        if (!this.resizing && (oldSize <= 1.0f && this.scrollBarSize > 1.0f || this.scrollBarSize <= 1.0f && oldSize > 1.0f)) {
            this.resizing = true;
            this.constraint.apply();
            ((Fragment)this.parent).resize(((Workspace)this.getWorkspace()).getMinecraft(), ((Fragment)this.parent).getParentWidth(), ((Fragment)this.parent).getParentHeight());
            this.resizing = false;
        }
    }

    @Override
    public void m_6305_(PoseStack graphics, int mouseX, int mouseY, float partialTick) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        PoseStack stack = graphics;
        int scrollBar = Math.max(8, (int)((float)this.getDistance() * this.scrollBarSize));
        int space = this.getDistance() - scrollBar;
        int preSpace = (int)((float)space * this.scrollProg);
        if (this.renderMinecraftStyle() > 0) {
            ElementScrollBar.bindTexture(this.resourceTabItems());
            TextureDefinition texdefScroller = TEXDEF_SCROLLER;
            if (this.orientation == Orientation.VERTICAL) {
                int dist;
                RenderHelper.startDrawBatch();
                int i = this.height - 6;
                int x = this.getTop() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    RenderHelper.drawBatch(stack, this.getLeft(), x, 14.0, dist, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                RenderHelper.drawBatch(stack, this.getLeft(), this.getTop(), 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                RenderHelper.drawBatch(stack, this.getLeft(), this.getBottom() - 3, 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                RenderHelper.endDrawBatch();
                ElementScrollBar.bindTexture(this.resourceScroller());
                RenderHelper.startDrawBatch();
                i = scrollBar - 7 - 2;
                x = this.getTop() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    RenderHelper.drawBatch(stack, this.getLeft() + 1, x, 12.0, dist, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 4.0 / texdefScroller.height(), (double)(4 + dist) / texdefScroller.height());
                    i -= dist;
                    x += dist;
                }
                RenderHelper.drawBatch(stack, this.getLeft() + 1, this.getTop() + preSpace + 1, 12.0, 4.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 0.0 / texdefScroller.height(), 4.0 / texdefScroller.height());
                RenderHelper.drawBatch(stack, this.getLeft() + 1, this.getTop() + preSpace + scrollBar - 3 - 1, 12.0, 3.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 12.0 / texdefScroller.height(), 15.0 / texdefScroller.height());
                RenderHelper.endDrawBatch();
            } else {
                int dist;
                int i = this.width - 6;
                int x = this.getLeft() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    ElementScrollBar.draw(stack, x, this.getTop(), dist, 14.0, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.draw(stack, this.getLeft(), this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                ElementScrollBar.draw(stack, this.getRight() - 3, this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                ElementScrollBar.bindTexture(this.resourceScroller());
                i = scrollBar - 7 - 2;
                x = this.getLeft() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    ElementScrollBar.draw(stack, x, this.getTop() + 1, dist, 12.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 4.0 / texdefScroller.height(), (double)(4 + dist) / texdefScroller.height());
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.draw(stack, this.getLeft() + preSpace + 1, this.getTop() + 1, 4.0, 12.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 0.0 / texdefScroller.height(), 4.0 / texdefScroller.height());
                ElementScrollBar.draw(stack, this.getLeft() + preSpace + scrollBar - 3 - 1, this.getTop() + 1, 3.0, 12.0, 0.0, (double)texdefScroller.x1() / texdefScroller.width(), (double)texdefScroller.x2() / texdefScroller.width(), 12.0 / texdefScroller.height(), 15.0 / texdefScroller.height());
            }
        } else {
            this.fill(graphics, this.getTheme().elementScrollBarBackground, 0);
            if (this.orientation == Orientation.VERTICAL) {
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)(this.getLeft() + 6), (double)(this.getTop() + 4), 2.0, (double)(this.height - 8), 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)this.getLeft(), (double)(this.getTop() + preSpace), 14.0, (double)scrollBar, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBar, 255, (double)(this.getLeft() + 1), (double)(this.getTop() + preSpace + 1), 12.0, (double)(scrollBar - 2), 0.0);
            } else {
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)(this.getLeft() + 4), (double)(this.getTop() + 6), (double)(this.width - 8), 2.0, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBarBorder, 255, (double)(this.getLeft() + preSpace), (double)this.getTop(), (double)scrollBar, 14.0, 0.0);
                RenderHelper.drawColour(graphics, this.getTheme().elementScrollBar, 255, (double)(this.getLeft() + preSpace + 1), (double)(this.getTop() + 1), (double)(scrollBar - 2), 12.0, 0.0);
            }
        }
    }

    public int getDistance() {
        return this.orientation == Orientation.VERTICAL ? this.height : this.width;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.pos = new Element.MousePos((int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.pos != null) {
            int moved = this.orientation == Orientation.VERTICAL ? (int)mouseY - this.pos.y : (int)mouseX - this.pos.x;
            if (moved != 0) {
                this.setScrollProg(this.scrollProg + (float)moved / ((float)this.getDistance() * (1.0f - this.scrollBarSize)));
            }
            this.pos.x = (int)mouseX;
            this.pos.y = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.m_5953_(mouseX, mouseY) && this.scrollBarSize < 1.0f) {
            if (Screen.m_96638_()) {
                this.setScrollProg((float)scrollY * -100.0f);
            } else if (Screen.m_96637_()) {
                this.setScrollProg(this.scrollProg + (float)(scrollY * -0.01));
            } else {
                this.secondHandScroll(scrollY);
            }
            return true;
        }
        return false;
    }

    public void secondHandScroll(double dist) {
        this.setScrollProg(this.scrollProg + (float)(dist * -0.1));
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.pos = null;
        super.m_6348_(mouseX, mouseY, button);
        ((Fragment)this.parent).m_7522_(null);
        return this.m_7222_() != null && this.m_7222_().m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_5755_(boolean direction) {
        return false;
    }

    @Override
    public int getMinWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMinHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMaxWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.HORIZONTAL ? 10000 : 0);
    }

    @Override
    public int getMaxHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.VERTICAL ? 10000 : 0);
    }

    public static void draw(PoseStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f matrix = stack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, (float)posX, (float)(posY + height), (float)zLevel).m_7421_((float)u2, (float)v1).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).m_7421_((float)u2, (float)v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)(posX + width), (float)posY, (float)zLevel).m_7421_((float)u1, (float)v2).m_5752_();
        bufferbuilder.m_85982_(matrix, (float)posX, (float)posY, (float)zLevel).m_7421_((float)u1, (float)v1).m_5752_();
        tessellator.m_85914_();
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

