/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import java.util.function.Supplier;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGrid;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridInventory;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.PacketGridSync;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketGridToServer
extends PacketGridSync {
    private final ItemStack[] stacks;

    public void toBytes(FriendlyByteBuf buf) {
        this.convertToBytes(buf);
        buf.writeInt(this.stacks.length);
        for (ItemStack stack : this.stacks) {
            buf.m_130055_(stack);
        }
    }

    public PacketGridToServer(FriendlyByteBuf buf) {
        this.convertFromBytes(buf);
        int len = buf.readInt();
        this.stacks = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            this.stacks[i] = buf.m_130267_();
        }
    }

    public PacketGridToServer(BlockPos pos, ResourceKey<Level> type, CraftingGrid grid) {
        this.init(pos, type, grid);
        this.stacks = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            this.stacks[i] = grid.getCraftingGridInventory().getStackInSlot(i);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            Level world = player.m_20193_();
            CraftingGridProvider provider = this.handleMessage((Level)LevelTools.getLevel((Level)world, (ResourceKey)this.type), (Player)player);
            if (provider != null) {
                CraftingGridInventory inventory = provider.getCraftingGrid().getCraftingGridInventory();
                for (int i = 0; i < 10; ++i) {
                    inventory.setStackInSlot(i, this.stacks[i]);
                }
                provider.markInventoryDirty();
            }
        });
        ctx.setPacketHandled(true);
    }
}

