/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Peripherals;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.NonNullConsumer;

public final class WiredModemLocalPeripheral {
    private static final String NBT_PERIPHERAL_TYPE = "PeripheralType";
    private static final String NBT_PERIPHERAL_ID = "PeripheralId";
    private int id = -1;
    private String type;
    private IPeripheral peripheral;
    private final NonNullConsumer<Object> invalidate = x -> invalidate.run();

    public WiredModemLocalPeripheral(@Nonnull Runnable invalidate) {
    }

    public boolean attach(@Nonnull Level world, @Nonnull BlockPos origin, @Nonnull Direction direction) {
        IPeripheral oldPeripheral = this.peripheral;
        this.peripheral = this.getPeripheralFrom(world, origin, direction);
        IPeripheral peripheral = this.peripheral;
        if (peripheral == null) {
            return oldPeripheral != null;
        }
        String type = peripheral.getType();
        int id = this.id;
        if (id > 0 && this.type == null) {
            this.type = type;
        } else if (id < 0 || !type.equals(this.type)) {
            this.type = type;
            this.id = ServerContext.get(world.m_7654_()).getNextId("peripheral." + type);
        }
        return oldPeripheral == null || !oldPeripheral.equals(peripheral);
    }

    public boolean detach() {
        if (this.peripheral == null) {
            return false;
        }
        this.peripheral = null;
        return true;
    }

    @Nullable
    public String getConnectedName() {
        return this.peripheral != null ? this.type + "_" + this.id : null;
    }

    @Nullable
    public IPeripheral getPeripheral() {
        return this.peripheral;
    }

    public boolean hasPeripheral() {
        return this.peripheral != null;
    }

    public void extendMap(@Nonnull Map<String, IPeripheral> peripherals) {
        if (this.peripheral != null) {
            peripherals.put(this.type + "_" + this.id, this.peripheral);
        }
    }

    public Map<String, IPeripheral> toMap() {
        return this.peripheral == null ? Collections.emptyMap() : Collections.singletonMap(this.type + "_" + this.id, this.peripheral);
    }

    public void write(@Nonnull CompoundTag tag, @Nonnull String suffix) {
        if (this.id >= 0) {
            tag.m_128405_(NBT_PERIPHERAL_ID + suffix, this.id);
        }
        if (this.type != null) {
            tag.m_128359_(NBT_PERIPHERAL_TYPE + suffix, this.type);
        }
    }

    public void read(@Nonnull CompoundTag tag, @Nonnull String suffix) {
        this.id = tag.m_128425_(NBT_PERIPHERAL_ID + suffix, 99) ? tag.m_128451_(NBT_PERIPHERAL_ID + suffix) : -1;
        this.type = tag.m_128425_(NBT_PERIPHERAL_TYPE + suffix, 8) ? tag.m_128461_(NBT_PERIPHERAL_TYPE + suffix) : null;
    }

    @Nullable
    private IPeripheral getPeripheralFrom(Level world, BlockPos pos, Direction direction) {
        BlockPos offset = pos.m_121945_(direction);
        Block block = world.m_8055_(offset).m_60734_();
        if (block == Registry.ModBlocks.WIRED_MODEM_FULL.get() || block == Registry.ModBlocks.CABLE.get()) {
            return null;
        }
        IPeripheral peripheral = Peripherals.getPeripheral(world, offset, direction.m_122424_(), this.invalidate);
        return peripheral instanceof WiredModemPeripheral ? null : peripheral;
    }
}

