/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbauxilium;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.ftb.mods.ftbauxilium.FTBAuxilium;
import dev.ftb.mods.ftbauxilium.auxilium.ModpackData;
import dev.ftb.mods.ftbauxilium.auxilium.SessionCollector;
import dev.ftb.mods.ftbauxilium.auxilium.StatManager;
import dev.ftb.mods.ftbauxilium.auxilium.SystemStats;
import dev.ftb.mods.ftbauxilium.tasks.OptTask;
import java.io.IOException;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ApiManager {
    private static final String BASE_URL = "https://auxilium.ftb.team/";
    private static final String CLIENT_API_VERSION = "1.0.0";
    private static final ApiManager INSTANCE;
    private static final Logger LOGGER;

    private ApiManager() {
    }

    public static ApiManager get() {
        return INSTANCE;
    }

    public boolean systemStarted(SystemStats stats) {
        PostRequest request = new PostRequest("system", stats);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to send system info to the api");
            return false;
        }
        LOGGER.debug("System info successfully posted to the api");
        return true;
    }

    public boolean modpackData(ModpackData data) {
        PostRequest request = new PostRequest("modpack", data);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to send mod pack data");
            return false;
        }
        LOGGER.debug("Mod pack data successfully posted to the api");
        return true;
    }

    @Nullable
    public String startSession() {
        PostRequest request = new PostRequest("session/start");
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful || !response.has("sessionId")) {
            LOGGER.debug("Failed to fetch a valid session");
            return null;
        }
        LOGGER.debug("API Session has been started");
        return response.get("sessionId").getAsString();
    }

    public void endSession(SessionCollector data) {
        PostRequest request = new PostRequest("session/stop", data);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to send session data");
            return;
        }
        LOGGER.debug("API Session has been ended");
    }

    public void sendCrashReport(String report) {
        PostRequest request = new PostRequest("crashes", new CrashWrapper(report));
        request.post();
    }

    public boolean optOut(UUID identifier, OptTask.JustPackData packData) {
        PostRequest request = new PostRequest("opt-out", packData, identifier);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to opt out");
            return false;
        }
        LOGGER.debug("User was opted out");
        return true;
    }

    public boolean optIn(UUID identifier, OptTask.JustPackData packData) {
        PostRequest request = new PostRequest("opt-in", packData, identifier);
        JsonObject response = request.post();
        if (response == null || !request.wasSuccessful) {
            LOGGER.debug("Failed to opt in");
            return false;
        }
        LOGGER.debug("User was opted in");
        return true;
    }

    static {
        LOGGER = LogManager.getLogger((String)"FTB Auxilium API");
        INSTANCE = new ApiManager();
    }

    public static class PostRequest {
        private static final int TIMEOUT = 10000;
        public String url;
        public Object body;
        public boolean wasSuccessful = false;
        public JsonObject response;
        private UUID identifier;

        public PostRequest(String url) {
            this(url, null, null);
        }

        public PostRequest(String url, @Nullable Object body) {
            this(url, body, null);
        }

        public PostRequest(String url, @Nullable Object body, @Nullable UUID identifier) {
            this.body = body;
            this.url = url;
            this.identifier = identifier;
        }

        @Nullable
        public JsonObject post() {
            try {
                RequestBuilder requestBuilder = RequestBuilder.post().setUri(ApiManager.BASE_URL + this.url).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + (this.identifier != null ? this.identifier : StatManager.identifier().getIdentifier())).addHeader("User-Agent", "FTB Auxilium Client (version: 1.0.0)").addHeader("API-VERSION", ApiManager.CLIENT_API_VERSION).setConfig(RequestConfig.custom().setMaxRedirects(4).setConnectTimeout(10000).setConnectionRequestTimeout(10000).build());
                if (this.body != null) {
                    requestBuilder.setEntity((HttpEntity)new StringEntity(new Gson().toJson(this.body)));
                }
                HttpUriRequest build = requestBuilder.build();
                CloseableHttpResponse execute = HttpClients.createDefault().execute(build);
                try {
                    int statusCode = execute.getStatusLine().getStatusCode();
                    if (statusCode == 404 || statusCode == 403) {
                        LOGGER.debug("Request rejected from server at {}", (Object)this.url);
                        return null;
                    }
                    JsonElement parse = new JsonParser().parse(EntityUtils.toString((HttpEntity)execute.getEntity()));
                    this.response = parse.getAsJsonObject();
                    this.wasSuccessful = this.response.has("success") && this.response.get("success").getAsBoolean();
                    LOGGER.debug("Successful post response from {}", (Object)this.url);
                    return this.response;
                }
                catch (JsonParseException exception) {
                    this.wasSuccessful = false;
                    LOGGER.debug("Failed to parse json response from {}", (Object)this.url);
                    return null;
                }
            }
            catch (IOException e) {
                this.wasSuccessful = false;
                LOGGER.debug("Failed to make request due to", (Throwable)e);
                return null;
            }
        }
    }

    public static class CrashWrapper {
        public String crashData;
        public int packId;
        public int packVersion;

        public CrashWrapper(String crashData) {
            this.crashData = crashData;
            ModpackData packData = FTBAuxilium.STAT_MANAGER.getPackData();
            if (packData != null && packData.id != -1 && packData.versionId != -1) {
                this.packId = packData.id;
                this.packVersion = packData.versionId;
            }
        }
    }
}

