/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createendertransmission.blocks;

import com.forsteri.createendertransmission.CreateEnderTransmission;
import com.forsteri.createendertransmission.blocks.MatterTransmitterNetwork;
import com.forsteri.createendertransmission.transmitUtil.ITransmitter;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMatterTransmitterBlockEntity
extends KineticBlockEntity
implements ITransmitter {
    public LazyOptional<?> capability = LazyOptional.of(() -> this.getCapability().apply(this::getInv));

    public AbstractMatterTransmitterBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected abstract MatterTransmitterNetwork getNetwork();

    protected abstract Function<Supplier<INBTSerializable<CompoundTag>>, ?> getCapability();

    public INBTSerializable<CompoundTag> getInv() {
        Map<String, INBTSerializable<CompoundTag>> channel = this.getNetwork().channels.get(this.getChannel());
        if (channel.containsKey(this.getPassword())) {
            return channel.get(this.getPassword());
        }
        INBTSerializable<CompoundTag> inv = this.getNetwork().defaultInv.get();
        channel.put(this.getPassword(), inv);
        CreateEnderTransmission.savedData.m_77762_();
        return inv;
    }

    protected abstract Predicate<Capability<?>> getMatterCapPredicate();

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (this.getMatterCapPredicate().test(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void reloadSettings() {
        ITransmitter.super.reloadSettings();
    }
}

