/*
 * Decompiled with CFR 0.152.
 */
package net.manmaed.petrock.worldgen.ores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.manmaed.petrock.worldgen.ores.PROres;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record OreBiomeModifier(GenerationStep.Decoration generationStage, HolderSet<PlacedFeature> placedFeature) implements BiomeModifier
{
    public static Codec<OreBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.comapFlatMap(OreBiomeModifier::generationStageFromString, Enum::toString).fieldOf("generation_stage").forGetter(OreBiomeModifier::generationStage), (App)PlacedFeature.f_191774_.fieldOf("features").forGetter(OreBiomeModifier::placedFeature)).apply((Applicative)builder, OreBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (!(phase != BiomeModifier.Phase.ADD || biome.m_203656_(BiomeTags.f_215818_) && biome.m_203656_(BiomeTags.f_207612_))) {
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            this.placedFeature.forEach(placedFeatureHolder -> generationSettings.m_204201_(this.generationStage, placedFeatureHolder));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)PROres.ORE_BIOME_MODIFIER.get();
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name));
        }
        catch (Exception e) {
            return DataResult.error((String)("Not a decoration stage: " + name));
        }
    }
}

