/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.audio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.file.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AudioElementController {
    public static final File METAS_FILE = new File(FancyMenu.MOD_DIR, "/audio_element_controller_metas.json");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, AudioElementMeta> METAS = new HashMap<String, AudioElementMeta>();
    private static boolean initialized = false;

    protected static void read() {
        METAS.clear();
        try {
            METAS_FILE.createNewFile();
            List<String> jsonList = FileUtils.readTextLinesFrom(METAS_FILE);
            StringBuilder json = new StringBuilder();
            jsonList.forEach(json::append);
            String jsonString = json.toString();
            if (jsonString.isBlank()) {
                return;
            }
            List metasList = (List)GSON.fromJson(jsonString, new TypeToken<List<AudioElementMeta>>(){}.getType());
            for (AudioElementMeta meta : metasList) {
                METAS.put(Objects.requireNonNull(meta.element_identifier), meta);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to read Audio element controller metas from file!", (Throwable)ex);
        }
    }

    protected static void write() {
        if (!initialized) {
            AudioElementController.read();
        }
        initialized = true;
        try {
            METAS_FILE.createNewFile();
            ArrayList<AudioElementMeta> metasList = new ArrayList<AudioElementMeta>(METAS.values());
            String json = GSON.toJson(metasList);
            FileUtils.writeTextToFile((File)METAS_FILE, (boolean)false, (String[])new String[]{Objects.requireNonNull(json)});
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to write Audio element controller metas to file!", (Throwable)ex);
        }
    }

    public static void syncChanges() {
        if (!initialized) {
            AudioElementController.read();
        }
        initialized = true;
        AudioElementController.write();
    }

    @Nullable
    public static AudioElementMeta getMeta(@NotNull String elementIdentifier) {
        if (!initialized) {
            AudioElementController.read();
        }
        initialized = true;
        return METAS.get(elementIdentifier);
    }

    public static void putMeta(@NotNull String elementIdentifier, @NotNull AudioElementMeta meta) {
        if (!initialized) {
            AudioElementController.read();
        }
        initialized = true;
        METAS.put(elementIdentifier, meta);
        AudioElementController.syncChanges();
    }

    public static class AudioElementMeta {
        public String element_identifier;
        public float volume;

        public AudioElementMeta(@NotNull String element_identifier, float volume) {
            this.element_identifier = element_identifier;
            this.volume = volume;
        }
    }
}

