/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib;

import cech12.bucketlib.api.BucketLibTags;
import cech12.bucketlib.api.crafting.FluidIngredient;
import cech12.bucketlib.api.crafting.MilkIngredient;
import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.config.ServerConfig;
import cech12.bucketlib.item.UniversalBucketDispenseBehaviour;
import cech12.bucketlib.item.crafting.BucketDyeingRecipe;
import cech12.bucketlib.util.BucketLibUtil;
import cech12.bucketlib.util.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bucketlib")
public class BucketLib {
    public static DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"bucketlib");
    public static RegistryObject<RecipeSerializer<?>> BUCKET_DYEING_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("bucket_dyeing", () -> BucketDyeingRecipe.Serializer.INSTANCE);
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<UniversalBucketItem> buckets = new ArrayList<UniversalBucketItem>();

    public BucketLib() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        ServerConfig.loadConfig(ServerConfig.SERVER_CONFIG, FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("bucketlib-server.toml"));
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::processIMC);
        RECIPE_SERIALIZERS.register(eventBus);
        CraftingHelper.register((ResourceLocation)FluidIngredient.Serializer.NAME, (IIngredientSerializer)FluidIngredient.Serializer.INSTANCE);
        CraftingHelper.register((ResourceLocation)MilkIngredient.Serializer.NAME, (IIngredientSerializer)MilkIngredient.Serializer.INSTANCE);
    }

    public static List<UniversalBucketItem> getRegisteredBuckets() {
        return Collections.unmodifiableList(buckets);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        BucketLibTags.init();
    }

    private void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(imcMessage -> {
            ResourceLocation bucketLocation;
            if (!"bucketlib".equals(imcMessage.modId())) {
                LOGGER.warn("Bucket could not be registered. The mod id \"{}\" of the IMCMessage is not \"{}\"", (Object)imcMessage.modId(), (Object)"bucketlib");
                return;
            }
            if (!"register_bucket".equals(imcMessage.method())) {
                LOGGER.warn("Bucket could not be registered. The method \"{}\" of the IMCMessage is not \"{}\"", (Object)imcMessage.method(), (Object)"register_bucket");
                return;
            }
            Object patt4242$temp = imcMessage.messageSupplier().get();
            if (patt4242$temp instanceof ResourceLocation && (bucketLocation = (ResourceLocation)patt4242$temp) != null) {
                Item bucketItem = (Item)ForgeRegistries.ITEMS.getValue(bucketLocation);
                if (bucketItem == null) {
                    LOGGER.info("Bucket could not be registered. The given ResourceLocation \"{}\" does not match any registered item in Forge registry.", (Object)bucketLocation);
                    return;
                }
                if (bucketItem instanceof UniversalBucketItem) {
                    UniversalBucketItem bucket = (UniversalBucketItem)bucketItem;
                    this.registerBucket(bucket);
                } else {
                    LOGGER.info("Bucket could not be registered. The item \"{}\" is not a {}.", (Object)bucketLocation, (Object)UniversalBucketItem.class.getName());
                }
            } else {
                LOGGER.warn("Bucket could not be registered. The message supplier of the IMCMessage does not contain a ResourceLocation");
            }
        });
    }

    private void registerBucket(UniversalBucketItem bucket) {
        buckets.add(bucket);
        DispenserBlock.m_52672_((ItemLike)bucket, (DispenseItemBehavior)UniversalBucketDispenseBehaviour.getInstance());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().getItemColors().m_92689_((stack, layer) -> {
            Fluid fluid;
            if (layer == 0 && bucket.isDyeable()) {
                return ColorUtil.getColor(stack, bucket.getDefaultColor());
            }
            if (layer == 1 && (fluid = BucketLibUtil.getFluid(stack)) != Fluids.f_76191_) {
                return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
            }
            return -1;
        }, new ItemLike[]{bucket}));
    }
}

