/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.events;

import com.google.common.collect.EvictingQueue;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.Pair;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="advancedperipherals", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    private static final String PLAYED_BEFORE = "ap_played_before";
    private static final int CHAT_QUEUE_MAX_SIZE = 50;
    private static final int PLAYER_QUEUE_MAX_SIZE = 50;
    public static final EvictingQueue<Pair<Long, ChatMessageObject>> messageQueue = EvictingQueue.create((int)50);
    public static final EvictingQueue<Pair<Long, PlayerMessageObject>> playerMessageQueue = EvictingQueue.create((int)50);
    private static long lastChatMessageID = 0L;
    private static long lastPlayerMessageID = 0L;

    @SubscribeEvent
    public static void onWorldJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (((Boolean)APConfig.WORLD_CONFIG.givePlayerBookOnJoin.get()).booleanValue() && !Events.hasPlayedBefore(player)) {
            ItemStack book = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("patchouli", "guide_book")));
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("patchouli:book", "advancedperipherals:manual");
            book.m_41751_(nbt);
            player.m_36356_(book);
        }
        Events.putPlayerMessage(Pair.of(Events.getLastPlayerMessageID(), new PlayerMessageObject("playerJoin", player.m_7755_().getString(), player.m_9236_().m_46472_().m_135782_().toString(), "")));
    }

    @SubscribeEvent
    public static void onWorldLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        Events.putPlayerMessage(Pair.of(Events.getLastPlayerMessageID(), new PlayerMessageObject("playerLeave", player.m_7755_().getString(), player.m_9236_().m_46472_().m_135782_().toString(), "")));
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        String fromDim = event.getFrom().m_135782_().toString();
        String toDim = event.getTo().m_135782_().toString();
        Events.putPlayerMessage(Pair.of(Events.getLastPlayerMessageID(), new PlayerMessageObject("playerChangedDimension", player.m_7755_().getString(), fromDim, toDim)));
    }

    @SubscribeEvent
    public static void onCommand(CommandEvent event) throws CommandSyntaxException {
        if (!Events.getCommandName(event.getParseResults().getContext()).equals("say")) {
            return;
        }
        String username = "sayCommand";
        String uuid = null;
        String message = MessageArgument.m_96835_((CommandContext)event.getParseResults().getContext().build("apChatEvent"), (String)"message").getString();
        boolean isHidden = false;
        CommandSourceStack source = (CommandSourceStack)event.getParseResults().getContext().getSource();
        if (source.m_81373_() != null) {
            username = source.m_81373_().m_5446_().getString();
            uuid = source.m_81373_().m_20148_().toString();
        }
        if (message.startsWith("$")) {
            event.setCanceled(true);
            message = message.replace("$", "");
            isHidden = true;
        }
        Events.putChatMessage(Pair.of(Events.getLastChatMessageID(), new ChatMessageObject(username, message, uuid, isHidden)));
    }

    private static String getCommandName(CommandContextBuilder<?> context) {
        if (context != null && context.getNodes() != null && !context.getNodes().isEmpty()) {
            return ((ParsedCommandNode)context.getNodes().get(0)).getNode().getName();
        }
        return "";
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChatBox(ServerChatEvent.Submitted event) {
        if (((Boolean)APConfig.PERIPHERALS_CONFIG.enableChatBox.get()).booleanValue()) {
            String message = event.getMessage().getString();
            boolean isHidden = false;
            if (message.startsWith("$")) {
                event.setCanceled(true);
                message = message.replace("$", "");
                isHidden = true;
            }
            Events.putChatMessage(Pair.of(Events.getLastChatMessageID(), new ChatMessageObject(event.getUsername(), message, event.getPlayer().m_20148_().toString(), isHidden)));
        }
    }

    public static synchronized void putChatMessage(Pair<Long, ChatMessageObject> message) {
        messageQueue.add(message);
        ++lastChatMessageID;
    }

    public static synchronized void putPlayerMessage(Pair<Long, PlayerMessageObject> message) {
        playerMessageQueue.add(message);
        ++lastPlayerMessageID;
    }

    public static synchronized long traverseChatMessages(long lastConsumedMessage, Consumer<ChatMessageObject> consumer) {
        for (Pair message : messageQueue) {
            if ((Long)message.getLeft() <= lastConsumedMessage) continue;
            consumer.accept((ChatMessageObject)message.getRight());
            lastConsumedMessage = (Long)message.getLeft();
        }
        return lastConsumedMessage;
    }

    public static synchronized long traversePlayerMessages(long lastConsumedMessage, Consumer<PlayerMessageObject> consumer) {
        for (Pair message : playerMessageQueue) {
            if ((Long)message.getLeft() <= lastConsumedMessage) continue;
            consumer.accept((PlayerMessageObject)message.getRight());
            lastConsumedMessage = (Long)message.getLeft();
        }
        return lastConsumedMessage;
    }

    public static synchronized long getLastChatMessageID() {
        return lastChatMessageID;
    }

    public static synchronized long getLastPlayerMessageID() {
        return lastPlayerMessageID;
    }

    private static boolean hasPlayedBefore(Player player) {
        CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
        if (tag.m_128471_(PLAYED_BEFORE)) {
            return true;
        }
        tag.m_128379_(PLAYED_BEFORE, true);
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
        return false;
    }

    public record PlayerMessageObject(String eventName, String playerName, String fromDimension, String toDimension) {
    }

    public record ChatMessageObject(String username, String message, String uuid, boolean isHidden) {
    }
}

