/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.computer.Environment;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.ChunkyPeripheral;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="advancedperipherals")
public class APCommands {
    public static final String ROOT_LITERAL = "advancedperipherals";
    public static final String FORCELOAD_LITERAL = "forceload";
    static final String FORCELOAD_HELP = "/advancedperipherals forceload help - show this help message\n/advancedperipherals forceload dump - show all chunky turtles\n";
    public static final String EXEC_LITERAL = "safe-exec";
    public static final String ROOT_SAFE_EXEC_LITERAL = "ap-safe-exec";

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        LiteralCommandNode safeExecNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)EXEC_LITERAL).then(Commands.m_82129_((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(APCommands::safeExecute))).build();
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)ROOT_LITERAL).then(Commands.m_82127_((String)"getHashItem").executes(context -> APCommands.getHashItem((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)FORCELOAD_LITERAL).executes(context -> APCommands.forceloadHelp((CommandSourceStack)context.getSource()))).then(Commands.m_82127_((String)"help").executes(context -> APCommands.forceloadHelp((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump").requires((Predicate)UserLevel.OWNER_OP)).executes(context -> APCommands.forceloadDump((CommandSourceStack)context.getSource()))))).then((CommandNode)safeExecNode));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)ROOT_SAFE_EXEC_LITERAL).redirect((CommandNode)safeExecNode));
    }

    private static int getHashItem(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer playerEntity = source.m_81375_();
        if (playerEntity.m_21205_().m_41619_()) {
            source.m_81352_((Component)Component.m_237113_((String)"You need an item in your main hand."));
            return 0;
        }
        String fingerprint = ItemUtil.getFingerprint(playerEntity.m_21205_());
        if (fingerprint.isEmpty()) {
            source.m_81352_((Component)Component.m_237113_((String)"There was an issue while generating the hash. Report to Author"));
            return 0;
        }
        source.m_81354_((Component)Component.m_237113_((String)"Fingerprint of the item: "), true);
        source.m_81354_((Component)ComponentUtils.m_130748_((Component)Component.m_237113_((String)fingerprint).m_130938_(style -> style.m_131157_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, fingerprint)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Copy"))))), true);
        return 1;
    }

    private static int forceloadHelp(CommandSourceStack source) throws CommandSyntaxException {
        source.m_81354_((Component)Component.m_237113_((String)FORCELOAD_HELP), true);
        return 1;
    }

    private static int forceloadDump(CommandSourceStack source) throws CommandSyntaxException {
        ServerComputer[] computers;
        TableBuilder table = new TableBuilder("ChunkyTurtles", new String[]{"Computer", "Position"});
        for (ServerComputer computer2 : computers = (ServerComputer[])ServerContext.get((MinecraftServer)source.m_81377_()).registry().getComputers().stream().filter(computer -> {
            Environment env = computer.getComputer().getEnvironment();
            for (ComputerSide side : ComputerSide.values()) {
                if (!(env.getPeripheral(side) instanceof ChunkyPeripheral)) continue;
                return true;
            }
            return false;
        }).sorted((a, b) -> a.getID() - b.getID()).toArray(ServerComputer[]::new)) {
            table.row(new Component[]{APCommands.makeComputerDumpCommand(computer2), APCommands.makeComputerPosCommand(computer2)});
        }
        table.display(source);
        return computers.length;
    }

    private static int safeExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = ((CommandSourceStack)context.getSource()).m_81325_(0);
        String command = StringArgumentType.getString(context, (String)"command");
        try {
            return source.m_81377_().m_129892_().m_230957_(source, command);
        }
        catch (RuntimeException e) {
            source.m_81352_((Component)Component.m_237113_((String)e.getMessage()));
            return 0;
        }
    }

    private static Component makeComputerDumpCommand(ServerComputer computer) {
        return ChatHelpers.link((MutableComponent)Component.m_237113_((String)("#" + computer.getID())), (String)("/computercraft dump " + computer.getInstanceID()), (Component)Component.m_237115_((String)"commands.computercraft.dump.action"));
    }

    private static Component makeComputerPosCommand(ServerComputer computer) {
        return ChatHelpers.link((MutableComponent)ChatHelpers.position((BlockPos)computer.getPosition()), (String)("/computercraft tp " + computer.getInstanceID()), (Component)Component.m_237115_((String)"commands.computercraft.tp.action"));
    }
}

