/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels.item;

import java.util.ArrayList;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import tfar.metalbarrels.item.UpgradeInfo;

public class BarrelUpgradeItem
extends Item {
    protected final UpgradeInfo upgradeInfo;

    public BarrelUpgradeItem(Item.Properties properties, UpgradeInfo info) {
        super(properties);
        this.upgradeInfo = info;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        ItemStack heldStack = context.m_43722_();
        BlockState state = world.m_8055_(pos);
        if (player == null || !this.upgradeInfo.canUpgrade(world.m_8055_(pos))) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_ || player.m_20089_() != Pose.CROUCHING) {
            return InteractionResult.PASS;
        }
        if (state.m_60734_() instanceof BarrelBlock && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
            player.m_5661_((Component)Component.m_237115_((String)"metalbarrels.in_use").m_130948_(Style.f_131099_.m_131157_(ChatFormatting.RED)), true);
            return InteractionResult.PASS;
        }
        BlockEntity oldBarrel = world.m_7702_(pos);
        ArrayList oldBarrelContents = new ArrayList();
        Direction facing = Direction.NORTH;
        if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        }
        oldBarrel.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).forEach(oldBarrelContents::add));
        oldBarrel.m_7651_();
        Block newBlock = this.upgradeInfo.getBlock(state);
        BlockState newState = newBlock.m_49966_();
        if (newState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
        } else if (newState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing);
        }
        world.m_7731_(pos, newState, 3);
        BlockEntity newBarrel = world.m_7702_(pos);
        newBarrel.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> IntStream.range(0, oldBarrelContents.size()).forEach(i -> itemHandler.insertItem(i, (ItemStack)oldBarrelContents.get(i), false)));
        if (!player.m_150110_().f_35937_) {
            heldStack.m_41774_(1);
        }
        player.m_5661_((Component)Component.m_237115_((String)"metalbarrels.upgrade_successful").m_130948_(Style.f_131099_.m_131157_(ChatFormatting.GREEN)), true);
        return InteractionResult.SUCCESS;
    }

    public UpgradeInfo getUpgradeInfo() {
        return this.upgradeInfo;
    }
}

