/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutilities;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.darkutilities.Content;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class DarkUtilsCommon {
    public static final List<BiFunction<Player, Predicate<ItemStack>, Boolean>> charmResolvers = new ArrayList<BiFunction<Player, Predicate<ItemStack>, Boolean>>();
    private static DarkUtilsCommon instance;
    public final Content content = new Content();

    public DarkUtilsCommon() {
        Services.REGISTRIES.loadContent((RegistryDataProvider)this.content);
        Services.EVENTS.addItemTooltipListener(this::addDescriptionTooltips);
        charmResolvers.add(DarkUtilsCommon::hasItemInVanillaInventory);
    }

    public static DarkUtilsCommon getInstance() {
        if (instance == null) {
            instance = new DarkUtilsCommon();
        }
        return instance;
    }

    private void addDescriptionTooltips(ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        Component description = this.content.tooltipCache.get(stack.m_41720_());
        if (description != null) {
            tooltip.add(description);
        }
    }

    public static boolean hasItem(Entity entity, Supplier<Item> item) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return charmResolvers.stream().anyMatch(func -> (Boolean)func.apply(player, arg_0 -> DarkUtilsCommon.lambda$hasItem$0((Supplier)item, arg_0)));
        }
        return false;
    }

    private static boolean hasItemInVanillaInventory(Player player, Predicate<ItemStack> predicate) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!predicate.test(stack)) continue;
            return true;
        }
        for (EquipmentSlot slotType : EquipmentSlot.values()) {
            if (!predicate.test(player.m_6844_(slotType))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$hasItem$0(Supplier item, ItemStack s) {
        return s.m_150930_((Item)item.get());
    }
}

