/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraftforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={ModelBlockRenderer.class})
public class MixinBlockModelRenderer {
    private final XoroshiroRandomSource random = new XoroshiroRandomSource(42L);

    @Overwrite(remap=false)
    public void renderModel(PoseStack.Pose entry, VertexConsumer vertexConsumer, BlockState blockState, BakedModel bakedModel, float red, float green, float blue, int light, int overlay, ModelData data, RenderType layer) {
        QuadVertexSink drain = VertexDrain.of(vertexConsumer).createSink(VanillaVertexTypes.QUADS);
        XoroshiroRandomSource random = this.random;
        red = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
        green = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
        blue = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
        int defaultColor = ColorABGR.pack(red, green, blue, 1.0f);
        for (Direction direction : DirectionUtil.ALL_DIRECTIONS) {
            random.m_188584_(42L);
            List quads = bakedModel.getQuads(blockState, direction, (RandomSource)random, data, layer);
            if (quads.isEmpty()) continue;
            MixinBlockModelRenderer.renderQuad(entry, drain, defaultColor, quads, light, overlay);
        }
        random.m_188584_(42L);
        List quads = bakedModel.getQuads(blockState, null, (RandomSource)random, data, layer);
        if (!quads.isEmpty()) {
            MixinBlockModelRenderer.renderQuad(entry, drain, defaultColor, quads, light, overlay);
        }
        drain.flush();
    }

    private static void renderQuad(PoseStack.Pose entry, QuadVertexSink drain, int defaultColor, List<BakedQuad> list, int light, int overlay) {
        if (list.isEmpty()) {
            return;
        }
        drain.ensureCapacity(list.size() * 4);
        for (BakedQuad bakedQuad : list) {
            int color = bakedQuad.m_111304_() ? defaultColor : -1;
            ModelQuadView quad = (ModelQuadView)bakedQuad;
            for (int i = 0; i < 4; ++i) {
                drain.writeQuad(entry, quad.getX(i), quad.getY(i), quad.getZ(i), color, quad.getTexU(i), quad.getTexV(i), light, overlay, ModelQuadUtil.getFacingNormal(bakedQuad.m_111306_(), quad.getNormal(i)));
            }
            SpriteUtil.markSpriteActive(quad.getSprite());
        }
    }
}

