/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile;

import com.google.common.primitives.Floats;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.gl.util.ElementRange;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.format.VanillaLikeChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.format.sfp.ModelVertexType;

public class ChunkBufferSorter {
    private static final ConcurrentHashMap<GlVertexFormat, PositionType> POSITIONS_BY_FORMAT = new ConcurrentHashMap();

    public static void sort(SortBuffer chunkData, float x, float y, float z) {
        PositionType type = POSITIONS_BY_FORMAT.computeIfAbsent(chunkData.vertexFormat(), format -> {
            try {
                format.getAttribute(VanillaLikeChunkMeshAttribute.POSITION);
                return PositionType.FLOAT_POSITION;
            }
            catch (NullPointerException nullPointerException) {
                try {
                    format.getAttribute(ChunkMeshAttribute.POSITION_ID);
                    return PositionType.COMPACT_POSITION;
                }
                catch (NullPointerException nullPointerException2) {
                    SodiumClientMod.logger().warn("Don't know how to sort {}", (Object)format.toString());
                    return PositionType.UNKNOWN_POSITION;
                }
            }
        });
        if (type == PositionType.UNKNOWN_POSITION) {
            return;
        }
        ByteBuffer vertexBuffer = chunkData.vertexBuffer();
        int vertexStride = chunkData.vertexFormat().getStride();
        IntBuffer indexBuffer = chunkData.indexBuffer().asIntBuffer();
        int vertexGroupCount = indexBuffer.capacity() / 3;
        float[] distanceArray = new float[vertexGroupCount];
        int[] indicesArray = new int[vertexGroupCount];
        for (int groupPtr = 0; groupPtr < vertexGroupCount; ++groupPtr) {
            float groupDistance;
            int v0 = indexBuffer.get();
            int v1 = indexBuffer.get();
            int v2 = indexBuffer.get();
            distanceArray[groupPtr] = groupDistance = ChunkBufferSorter.getDistanceSqSFP(vertexBuffer, type, x, y, z, vertexStride, v0, v1, v2);
            indicesArray[groupPtr] = groupPtr;
        }
        IntArrays.mergeSort((int[])indicesArray, (a, b) -> Floats.compare((float)distanceArray[b], (float)distanceArray[a]));
        IntBuffer tmpBuffer = IntBuffer.allocate(indexBuffer.capacity());
        for (int i = 0; i < vertexGroupCount; ++i) {
            int idxBase = indicesArray[i] * 3;
            tmpBuffer.put(indexBuffer.get(idxBase + 0));
            tmpBuffer.put(indexBuffer.get(idxBase + 1));
            tmpBuffer.put(indexBuffer.get(idxBase + 2));
        }
        tmpBuffer.rewind();
        indexBuffer.rewind();
        indexBuffer.put(tmpBuffer);
        indexBuffer.rewind();
    }

    private static float square(float f) {
        return f * f;
    }

    private static float distance(float x1, float x2, float y1, float y2, float z1, float z2) {
        return ChunkBufferSorter.square(x2 - x1) + ChunkBufferSorter.square(y2 - y1) + ChunkBufferSorter.square(z2 - z1);
    }

    private static float getX(ByteBuffer buffer, int vertexBaseBytes, PositionType type) {
        if (type == PositionType.FLOAT_POSITION) {
            return buffer.getFloat(vertexBaseBytes);
        }
        return ModelVertexType.decodePosition(buffer.getShort(vertexBaseBytes));
    }

    private static float getY(ByteBuffer buffer, int vertexBaseBytes, PositionType type) {
        if (type == PositionType.FLOAT_POSITION) {
            return buffer.getFloat(vertexBaseBytes + 4);
        }
        return ModelVertexType.decodePosition(buffer.getShort(vertexBaseBytes + 2));
    }

    private static float getZ(ByteBuffer buffer, int vertexBaseBytes, PositionType type) {
        if (type == PositionType.FLOAT_POSITION) {
            return buffer.getFloat(vertexBaseBytes + 8);
        }
        return ModelVertexType.decodePosition(buffer.getShort(vertexBaseBytes + 4));
    }

    private static float getDistanceSqSFP(ByteBuffer buffer, PositionType type, float xCenter, float yCenter, float zCenter, int stride, int v0, int v1, int v2) {
        float quadZ;
        float quadY;
        float quadX;
        int vertexBase = v0 * stride;
        int bufferLength = buffer.capacity();
        if (vertexBase >= bufferLength) {
            return Float.MAX_VALUE;
        }
        float x1 = ChunkBufferSorter.getX(buffer, vertexBase, type);
        float y1 = ChunkBufferSorter.getY(buffer, vertexBase, type);
        float z1 = ChunkBufferSorter.getZ(buffer, vertexBase, type);
        vertexBase = v1 * stride;
        if (vertexBase >= bufferLength) {
            return Float.MAX_VALUE;
        }
        float x2 = ChunkBufferSorter.getX(buffer, vertexBase, type);
        float y2 = ChunkBufferSorter.getY(buffer, vertexBase, type);
        float z2 = ChunkBufferSorter.getZ(buffer, vertexBase, type);
        vertexBase = v2 * stride;
        if (vertexBase >= bufferLength) {
            return Float.MAX_VALUE;
        }
        float x3 = ChunkBufferSorter.getX(buffer, vertexBase, type);
        float y3 = ChunkBufferSorter.getY(buffer, vertexBase, type);
        float z3 = ChunkBufferSorter.getZ(buffer, vertexBase, type);
        float d12 = ChunkBufferSorter.distance(x1, x2, y1, y2, z1, z2);
        float d23 = ChunkBufferSorter.distance(x2, x3, y2, y3, z2, z3);
        float d31 = ChunkBufferSorter.distance(x3, x1, y3, y1, z3, z1);
        if (d12 > d23) {
            if (d12 > d31) {
                quadX = (x1 + x2) / 2.0f;
                quadY = (y1 + y2) / 2.0f;
                quadZ = (z1 + z2) / 2.0f;
            } else {
                quadX = (x3 + x1) / 2.0f;
                quadY = (y3 + y1) / 2.0f;
                quadZ = (z3 + z1) / 2.0f;
            }
        } else if (d23 > d31) {
            quadX = (x2 + x3) / 2.0f;
            quadY = (y2 + y3) / 2.0f;
            quadZ = (z2 + z3) / 2.0f;
        } else {
            quadX = (x3 + x1) / 2.0f;
            quadY = (y3 + y1) / 2.0f;
            quadZ = (z3 + z1) / 2.0f;
        }
        float xDist = quadX - xCenter;
        float yDist = quadY - yCenter;
        float zDist = quadZ - zCenter;
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public record SortBuffer(ByteBuffer vertexBuffer, ByteBuffer indexBuffer, GlVertexFormat<?> vertexFormat, Map<ModelQuadFacing, ElementRange> parts) {
        public static SortBuffer copyFrom(ChunkMeshData mesh) {
            ByteBuffer vBuffer = ByteBuffer.allocate(mesh.getVertexData().vertexBuffer().getLength()).order(ByteOrder.nativeOrder());
            vBuffer.put(mesh.getVertexData().vertexBuffer().getDirectBuffer());
            vBuffer.flip();
            ByteBuffer iBuffer = ByteBuffer.allocate(mesh.getVertexData().indexBuffer().getLength()).order(ByteOrder.nativeOrder());
            iBuffer.put(mesh.getVertexData().indexBuffer().getDirectBuffer());
            iBuffer.flip();
            return new SortBuffer(vBuffer, iBuffer, mesh.getVertexData().vertexFormat(), mesh.getParts());
        }

        public static SortBuffer wrap(ChunkMeshData mesh) {
            return new SortBuffer(mesh.getVertexData().vertexBuffer().getDirectBuffer(), mesh.getVertexData().indexBuffer().getDirectBuffer(), mesh.getVertexData().vertexFormat(), mesh.getParts());
        }

        private static ByteBuffer cloneBuf(ByteBuffer b) {
            ByteBuffer clone = ByteBuffer.allocate(b.capacity()).order(b.order());
            b.rewind();
            clone.put(b);
            b.rewind();
            clone.flip();
            return clone;
        }

        public SortBuffer duplicate() {
            if (this.vertexBuffer.isDirect()) {
                throw new IllegalStateException("Cannot duplicate direct SortBuffer");
            }
            return new SortBuffer(SortBuffer.cloneBuf(this.vertexBuffer), SortBuffer.cloneBuf(this.indexBuffer), this.vertexFormat, this.parts);
        }
    }

    static enum PositionType {
        COMPACT_POSITION,
        FLOAT_POSITION,
        UNKNOWN_POSITION;

    }
}

