/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BatFamiliarEntity
extends FamiliarEntity
implements FlyingAnimal {
    public BatFamiliarEntity(EntityType<? extends BatFamiliarEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().m_22268_(Attributes.f_22280_, 0.4);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasRibbon()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        FamiliarEntity.SitGoal sitGoal = new FamiliarEntity.SitGoal(this, this);
        sitGoal.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21345_.m_25352_(2, (Goal)sitGoal);
        this.f_21345_.m_25352_(3, (Goal)new CannibalismGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos pos) {
                BlockState state = this.f_26495_.m_8055_(pos);
                return state.m_60795_() || !state.m_60767_().m_76334_();
            }
        };
        return navigation;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isSitting()) {
            this.m_20256_(Vec3.f_82478_);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setRibbon(this.m_217043_().m_188500_() < 0.1);
        this.setTail(this.m_217043_().m_188499_());
        this.setHair(this.m_217043_().m_188499_());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.m_14089_((float)(((float)this.f_19797_ + partialTicks) / 5.0f));
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        effects.add(new MobEffectInstance(MobEffects.f_19611_, 300, 1, false, false));
        if (this.hasBlacksmithUpgrade()) {
            effects.add(new MobEffectInstance((MobEffect)OccultismEffects.BAT_LIFESTEAL.get(), 300, 0, false, false));
        }
        return effects;
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasHair() {
        return this.hasVariant(0);
    }

    private void setHair(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasRibbon() {
        return this.hasVariant(1);
    }

    private void setRibbon(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasTail() {
        return this.hasVariant(2);
    }

    private void setTail(boolean b) {
        this.setVariant(2, b);
    }

    private static class CannibalismGoal
    extends Goal {
        BatFamiliarEntity bat;
        Bat nearby;

        private CannibalismGoal(BatFamiliarEntity bat) {
            this.bat = bat;
        }

        public boolean m_8036_() {
            this.nearby = this.nearbyBat();
            return this.nearby != null;
        }

        public void m_8056_() {
            if (this.nearby != null) {
                this.nearby.m_6469_(DamageSource.m_19370_((LivingEntity)this.bat), 10.0f);
                OccultismAdvancements.FAMILIAR.trigger(this.bat.getFamiliarOwner(), FamiliarTrigger.Type.BAT_EAT);
            }
        }

        private Bat nearbyBat() {
            Bat nearby = null;
            List bats = this.bat.f_19853_.m_45976_(Bat.class, this.bat.m_20191_().m_82400_(2.0));
            if (!bats.isEmpty()) {
                nearby = (Bat)bats.get(0);
            }
            return nearby;
        }
    }
}

