/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.player;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class TeleportDimensionSpawnCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"tpdim").requires(cs -> cs.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> TeleportDimensionSpawnCommand.teleport((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81377_(), List.of(((CommandSourceStack)ctx.getSource()).m_81375_()), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension")))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> TeleportDimensionSpawnCommand.teleport((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81377_(), EntityArgument.m_91461_((CommandContext)ctx, (String)"target"), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension")))));
    }

    private static int teleport(CommandSourceStack source, MinecraftServer server, Collection<? extends Entity> entities, ServerLevel dimension) {
        ServerLevel level = server.m_129880_(dimension.m_46472_());
        if (level == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Dimension not found"));
            return 0;
        }
        for (Entity entity : entities) {
            BlockPos pos = entity.m_20183_();
            if (!level.m_6857_().m_61937_(pos)) {
                pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(level.m_6857_().m_6347_(), 0.0, level.m_6857_().m_6345_()));
            }
            int playerXp = 0;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                playerXp = serverPlayer.f_36078_;
                serverPlayer.m_8999_(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), entity.m_146908_(), entity.m_146909_());
                serverPlayer.m_9174_(playerXp);
            } else {
                entity.m_6021_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            }
            if (!level.m_46749_(pos)) {
                level.m_46865_(pos);
            }
            if (!(entity instanceof ServerPlayer)) continue;
            BlockState playerFeetBlock = level.m_8055_(pos);
            BlockState playerHeadBlock = level.m_8055_(pos.m_7494_());
            if (playerHeadBlock.m_60795_() && playerFeetBlock.m_60795_()) continue;
            BoundingBox box = new BoundingBox(pos).m_191961_(1);
            BlockPos.m_121919_((BoundingBox)box).forEach(blockPos -> {
                BlockState state = level.m_8055_(blockPos);
                if (!state.m_60795_()) {
                    level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                }
            });
        }
        return 1;
    }
}

