/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.google.common.collect.HashMultiset;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sunekaer.toolkit.ToolkitPlatform;
import com.sunekaer.toolkit.utils.ChunkRangeIterator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MineAreaCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"minearea").requires(cs -> cs.m_6761_(2))).executes(context -> MineAreaCommand.mine((CommandSourceStack)context.getSource(), 1, ""))).then(Commands.m_82129_((String)"range", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> MineAreaCommand.mine((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"), "")));
    }

    private static int mine(CommandSourceStack source, int size, String filter) throws CommandSyntaxException {
        try {
            ItemStack breaker = new ItemStack((ItemLike)Items.f_42395_);
            breaker.m_41663_(Enchantments.f_44985_, 1);
            MinecraftServer server = source.m_81377_();
            ServerLevel level = source.m_81372_();
            ServerPlayer player = source.m_81375_();
            int range = Math.max(0, size / 2);
            ChunkRangeIterator iterator = new ChunkRangeIterator((Level)level, player.m_146902_(), range);
            HashMultiset drops = HashMultiset.create();
            while (iterator.hasNext()) {
                BlockPos blockPos = iterator.next();
                BlockState state = level.m_8055_(blockPos);
                if (state.m_60795_() || state.m_60713_(Blocks.f_50752_) || !state.m_204336_(ToolkitPlatform.getOresTag())) continue;
                List blockDrops = Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)blockPos, (BlockEntity)level.m_7702_(blockPos), (Entity)player, (ItemStack)breaker);
                for (ItemStack drop : blockDrops) {
                    drops.add((Object)drop.m_41720_(), drop.m_41613_());
                }
            }
            System.out.println(drops);
            int chests = drops.size() / 27;
            BlockPos playerPos = player.m_20183_();
            boolean finished = false;
            int rows = 0;
            int cols = 0;
            for (int i = 0; i < chests && !finished; ++i) {
                if (rows > 4) {
                    rows = 0;
                    ++cols;
                }
                BlockPos chestPos = playerPos.m_7918_(cols, 0, rows);
                level.m_46597_(chestPos, Blocks.f_50618_.m_49966_());
                BarrelBlockEntity chest = (BarrelBlockEntity)level.m_7702_(chestPos);
                if (chest == null) continue;
                Iterator iterator1 = drops.iterator();
                for (int j = 0; j < 27; ++j) {
                    if (!iterator1.hasNext()) {
                        finished = true;
                        break;
                    }
                    Item item = (Item)iterator1.next();
                    int count = drops.count((Object)item);
                    int taken = Math.min(count, 64);
                    chest.m_6836_(j, new ItemStack((ItemLike)item, taken));
                    drops.remove((Object)item, taken);
                }
                ++rows;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

