/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sunekaer.toolkit.ToolkitPlatform;
import com.sunekaer.toolkit.jobs.ServerTickJobRunner;
import com.sunekaer.toolkit.utils.ChunkRangeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ClearCommand {
    private static final AtomicBoolean COMPLETED = new AtomicBoolean(true);
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(cs -> cs.m_6761_(2))).executes(context -> ClearCommand.remove((CommandSourceStack)context.getSource(), 1, RemovalPredicate.NAMES[0]))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"range", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> ClearCommand.remove((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"), RemovalPredicate.NAMES[0]))).then(Commands.m_82129_((String)"filter", (ArgumentType)StringArgumentType.string()).suggests((commandContext, suggestionsBuilder) -> SharedSuggestionProvider.m_82967_((String[])RemovalPredicate.NAMES, (SuggestionsBuilder)suggestionsBuilder)).executes(ctx -> ClearCommand.remove((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"range"), StringArgumentType.getString((CommandContext)ctx, (String)"filter")))));
    }

    private static int remove(CommandSourceStack source, int size, String filter) throws CommandSyntaxException {
        if (!COMPLETED.get()) {
            source.m_81352_((Component)Component.m_237113_((String)"Already running, give it a second."));
            return 1;
        }
        COMPLETED.set(false);
        ServerPlayer player = source.m_81375_();
        RemovalPredicate removalCheck = RemovalPredicate.getFromName(filter).orElse(RemovalPredicate.JUST_ORES);
        Predicate<BlockState> customCheck = null;
        if (filter.startsWith("#")) {
            customCheck = state -> state.m_204336_(TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(filter.replace("#", ""))));
        } else if (filter.contains(":")) {
            customCheck = state -> Registry.f_122824_.m_7981_((Object)state.m_60734_()).toString().equalsIgnoreCase(filter);
        }
        ServerLevel level = source.m_81372_();
        source.m_81354_((Component)Component.m_237115_((String)"commands.toolkit.remove.lagwarring"), true);
        int range = size - 1;
        ChunkPos chunkPos = player.m_146902_();
        Predicate<BlockState> finalCustomCheck = customCheck;
        COMPLETED.set(false);
        for (int x = chunkPos.f_45578_ - range; x <= chunkPos.f_45578_ + range; ++x) {
            for (int z = chunkPos.f_45579_ - range; z <= chunkPos.f_45579_ + range; ++z) {
                ChunkPos currentChunkPos = new ChunkPos(x, z);
                boolean shouldComplete = x == chunkPos.f_45578_ + range && z == chunkPos.f_45579_ + range;
                ServerTickJobRunner.get().add(() -> {
                    ClearCommand.removeChunk(level, currentChunkPos, finalCustomCheck != null ? finalCustomCheck : removalCheck.stateCheck);
                    if (shouldComplete) {
                        COMPLETED.set(true);
                    }
                });
            }
        }
        return 1;
    }

    private static void removeChunk(ServerLevel level, ChunkPos chunkPos, Predicate<BlockState> blockCheck) {
        int maxHeight;
        BlockState airState = Blocks.f_50016_.m_49966_();
        ChunkRangeIterator iterator = new ChunkRangeIterator((Level)level, chunkPos, 1, true);
        ArrayList<BlockPos> updatedBlocks = new ArrayList<BlockPos>();
        int n = maxHeight = level.m_46472_() == ServerLevel.f_46429_ ? 127 : level.m_151558_();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_) {
                if (state.m_60795_() || pos.m_123342_() <= level.m_141937_() || pos.m_123342_() >= maxHeight) continue;
                level.m_7731_(pos, airState, 2);
                updatedBlocks.add(pos);
                continue;
            }
            if (blockCheck.test(state)) continue;
            level.m_7731_(pos, airState, 2);
            updatedBlocks.add(pos);
        }
        for (BlockPos pos : updatedBlocks) {
            level.m_6289_(pos, airState.m_60734_());
        }
    }

    private static enum RemovalPredicate {
        JUST_ORES(state -> state.m_204336_(ToolkitPlatform.getOresTag())),
        ORES_AND_MODDED(state -> state.m_204336_(ToolkitPlatform.getOresTag()) && Registry.f_122824_.m_7981_((Object)state.m_60734_()).m_135827_().equals("minecraft"));

        public static final List<RemovalPredicate> VALUES;
        public static final String[] NAMES;
        final Predicate<BlockState> stateCheck;

        private RemovalPredicate(Predicate<BlockState> stateCheck) {
            this.stateCheck = stateCheck;
        }

        public static Optional<RemovalPredicate> getFromName(String name) {
            return VALUES.stream().filter(e -> e.toString().toLowerCase().equals(name)).findFirst();
        }

        static {
            VALUES = Arrays.asList(RemovalPredicate.values());
            NAMES = (String[])VALUES.stream().map(e -> e.toString().toLowerCase()).toArray(String[]::new);
        }
    }
}

