/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.level;

import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sunekaer.toolkit.ToolkitPlatform;
import com.sunekaer.toolkit.utils.ChunkRangeIterator;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BlockDistributionCommand {
    private static final DecimalFormat FORMATTER = new DecimalFormat("########0.00");
    private static final DecimalFormat COMMA_FORMATTER = new DecimalFormat("#,###");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"oredist").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"area-size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(ctx -> BlockDistributionCommand.getOreDist((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_81375_(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"area-size"))));
    }

    private static int getOreDist(CommandSourceStack source, Player player, int size) {
        ServerLevel level = source.m_81372_();
        ChunkRangeIterator iterator = new ChunkRangeIterator((Level)level, player.m_146902_(), size);
        LinkedHashMultiset blockOccurrences = LinkedHashMultiset.create();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_() || state.m_60713_(Blocks.f_50752_) || state.m_60713_(Blocks.f_50069_) || state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_49990_) || !state.m_204336_(ToolkitPlatform.getOresTag())) continue;
            ResourceLocation key = Registry.f_122824_.m_7981_((Object)state.m_60734_());
            blockOccurrences.add((Object)key.toString());
        }
        double sum = blockOccurrences.size();
        if (sum == 0.0) {
            source.m_81354_((Component)Component.m_237113_((String)"No ores found").m_130940_(ChatFormatting.RED), true);
            return 1;
        }
        LinkedHashMultiset sortedSet = LinkedHashMultiset.create(blockOccurrences.entrySet().stream().sorted((a, b) -> Integer.compare(b.getCount(), a.getCount())).toList());
        source.m_81354_((Component)Component.m_237113_((String)("Block distribution for " + size + "x" + size + " chunks (total: " + COMMA_FORMATTER.format(sum) + ")")).m_130940_(ChatFormatting.GREEN), false);
        source.m_81354_((Component)Component.m_237113_((String)""), false);
        int i = 0;
        for (Multiset.Entry entry : sortedSet) {
            int white = i % 2 == 0 ? Objects.requireNonNull(ChatFormatting.WHITE.m_126665_()) : 0xC4C3C3;
            int yellow = i % 2 == 0 ? Objects.requireNonNull(ChatFormatting.YELLOW.m_126665_()) : 14013728;
            MutableComponent component = Component.m_237113_((String)"");
            component.m_7220_((Component)Component.m_237113_((String)"[")).m_130948_(Style.f_131099_.m_178520_(yellow));
            component.m_7220_((Component)Component.m_237113_((String)COMMA_FORMATTER.format(entry.getCount())).m_130948_(Style.f_131099_.m_178520_(yellow).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)(FORMATTER.format((double)(entry.getCount() * 100) / sum) + "%"))))));
            component.m_7220_((Component)Component.m_237113_((String)"]").m_130948_(Style.f_131099_.m_178520_(yellow)));
            component.m_7220_((Component)Component.m_237113_((String)(" " + (String)entry.getElement())).m_130948_(Style.f_131099_.m_178520_(white)));
            source.m_81354_((Component)component, false);
            ++i;
        }
        return 1;
    }
}

