/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.inventory;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sunekaer.toolkit.commands.inventory.InventoryCollector;
import com.sunekaer.toolkit.network.Handler;
import com.sunekaer.toolkit.network.SetCopy;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PrintCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"print").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests(InventoryCollector::suggestions).executes(context -> PrintCommand.print((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"type"), false)));
    }

    private static int print(CommandContext<CommandSourceStack> context, String typeInput, boolean copyOnReply) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        InventoryCollector type = InventoryCollector.fromString(typeInput);
        if (type == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Invalid type"));
            return 0;
        }
        ServerPlayer player = source.m_81375_();
        List<ItemStack> itemCollection = type.itemCollector.apply((Player)player);
        for (ItemStack stack : itemCollection) {
            String itemName = Objects.requireNonNull(stack.m_41720_().arch$registryName()).toString();
            List tags = stack.m_204131_().collect(Collectors.toList());
            String withNBT = "";
            if (stack.m_41782_()) {
                withNBT = stack.m_41784_().toString();
            }
            String combinedItemNBT = itemName + withNBT;
            source.m_81354_((Component)Component.m_237113_((String)combinedItemNBT).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, combinedItemNBT)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Copy tag"))).m_131140_(ChatFormatting.YELLOW)), false);
            if (copyOnReply) {
                Handler.CHANNEL.sendToPlayer(player, (Object)new SetCopy(combinedItemNBT));
            }
            if (tags.isEmpty()) continue;
            for (TagKey tag : tags) {
                String tagString = String.format("#%s", tag.f_203868_());
                source.m_81354_((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237113_((String)tagString).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, tagString)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Copy tag"))))), false);
            }
        }
        return 1;
    }

    public static ArgumentBuilder<CommandSourceStack, ?> registerHandCommand() {
        return Commands.m_82127_((String)"hand").executes(context -> PrintCommand.print((CommandContext<CommandSourceStack>)context, "hand", true));
    }
}

