/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container.component;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlanFlat;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.lwjgl.opengl.GL11;

public class GuiCraftingPlanFlat
extends AbstractWidget {
    private static final int COLUMNS = 2;
    private static final int COLUMN_PADDING = 2;
    private static final int ELEMENT_WIDTH = 110;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_HEIGHT_TOTAL = 18;
    protected static final int TICK_DELAY = 30;
    private final AbstractContainerScreen parentGui;
    private final int guiLeft;
    private final int guiTop;
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private final boolean valid;
    private final WidgetScrollBar scrollBar;
    private final String label;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;
    private int firstRow;

    public GuiCraftingPlanFlat(AbstractContainerScreen parentGui, ITerminalCraftingPlanFlat<?> craftingPlan, int guiLeft, int guiTop, int x, int y, int visibleRows) {
        super(x, y, 0, 0, (Component)Component.m_237113_((String)""));
        this.parentGui = parentGui;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.elements = GuiCraftingPlanFlat.getElements(craftingPlan);
        this.visibleElements = Lists.newArrayList(this.elements);
        this.valid = craftingPlan.getStatus().isValid();
        this.scrollBar = new WidgetScrollBar(guiLeft + x + 227, guiTop + y + 0, 178, (Component)Component.m_237115_((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, visibleRows);
        this.scrollBar.setTotalRows((int)Math.ceil(this.visibleElements.size() / 2));
        this.label = L10NHelpers.localize((String)craftingPlan.getUnlocalizedLabel(), (Object[])new Object[0]);
        this.tickDuration = craftingPlan.getTickDuration();
        this.channel = craftingPlan.getChannel();
        this.initiatorName = craftingPlan.getInitiatorName();
    }

    public void inheritVisualizationState(GuiCraftingPlanFlat guiCraftingPlan) {
        float lastScroll = guiCraftingPlan.scrollBar.getCurrentScroll();
        this.scrollBar.scrollTo(lastScroll);
        this.refreshList();
    }

    protected void refreshList() {
        this.scrollBar.setTotalRows(this.visibleElements.size());
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = Math.max(0, firstRow);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    protected List<Element> getVisibleElements() {
        return this.visibleElements.subList(this.firstRow, Math.min(this.visibleElements.size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    public void drawGuiContainerLayer(PoseStack matrixStack, int guiLeft, int guiTop, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int offsetY = 0;
        int column = 0;
        for (Element element : this.getVisibleElements()) {
            this.drawElement(matrixStack, element, guiLeft + this.f_93620_ + column * 112, guiTop + this.f_93621_ + offsetY, 110 + (column == 0 ? 1 : 0), 16, layer, partialTick, mouseX, mouseY);
            if (++column < 2) continue;
            column = 0;
            offsetY += 18;
        }
    }

    private void drawElement(PoseStack matrixStack, Element element, int x, int y, int width, int height, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            GuiCraftingPlanFlat.m_93172_((PoseStack)matrixStack, (int)x, (int)y, (int)(x + width), (int)(y + height + 1), (int)element.getColor());
        }
        int xOriginal = x;
        IPrototypedIngredient<?, ?> output = element.getInstance();
        IngredientComponent ingredientComponent = output.getComponent();
        long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
        int finalX = x;
        int finalY = y;
        ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY).ifPresent(h -> h.drawInstance(matrixStack, output.getPrototype(), quantity, "", this.parentGui, layer, partialTick, finalX, finalY, mouseX, mouseY, null));
        x = xOriginal + width - 50;
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            int moved = 0;
            if (element.getStorageQuantity() > 0L) {
                GuiCraftingPlanFlat.renderItem(RenderSystem.m_157191_(), new ItemStack((ItemLike)Blocks.f_50087_), x, y, 0.45f);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.stored", (Object[])new Object[]{element.getStorageQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
                y += 8;
                ++moved;
            }
            if (element.getToCraftQuantity() > 0L) {
                GuiCraftingPlanFlat.renderItem(RenderSystem.m_157191_(), new ItemStack((ItemLike)Blocks.f_50091_), x, y, 0.45f);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.to_craft", (Object[])new Object[]{element.getToCraftQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
                y += 8;
                ++moved;
            }
            if (element.getCraftingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlanFlat.renderItem(RenderSystem.m_157191_(), new ItemStack((ItemLike)Blocks.f_50091_), x, y, 0.45f);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.crafting", (Object[])new Object[]{element.getCraftingQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
                y += 8;
                ++moved;
            }
            if (element.getMissingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlanFlat.renderItem(RenderSystem.m_157191_(), new ItemStack((ItemLike)Blocks.f_50375_), x, y, 0.45f);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.missing", (Object[])new Object[]{element.getMissingQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected static void renderItem(PoseStack poseStack, ItemStack itemStack, int x, int y, float scale) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 0.0);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.m_157182_();
        RenderItemExtendedSlotCount renderItem = RenderItemExtendedSlotCount.getInstance();
        GlStateManager.m_84525_();
        GlStateManager.m_84328_((int)770, (int)771);
        Lighting.m_84931_();
        GlStateManager.m_84513_();
        GL11.glEnable((int)2929);
        renderItem.m_115203_(itemStack, 0, 0);
        renderItem.m_115174_(Minecraft.m_91087_().f_91062_, itemStack, 0, 0, "");
        Lighting.m_84930_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static String getDurationString(long tickDuration) {
        long durationMs = tickDuration * 1000L / 20L;
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.duration", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)durationMs, (String)"H:mm:ss", (boolean)true)});
    }

    public void drawGuiContainerBackgroundLayer(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        GuiCraftingPlanFlat.m_93208_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)this.label, (int)(this.guiLeft + this.f_93620_ + 110 + 8), (int)(this.guiTop + this.f_93621_ - 13), (int)0xFFFFFF);
        if (this.tickDuration >= 0L) {
            String durationString = GuiCraftingPlanFlat.getDurationString(this.tickDuration);
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)fontRenderer, (String)durationString, (int)(this.guiLeft + this.f_93620_ + 200), (int)(this.guiTop + this.f_93621_ - 14), (float)0.5f, (int)0xFFFFFF);
        }
        if (this.channel != -1) {
            String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{this.channel});
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)fontRenderer, (String)channelString, (int)(this.guiLeft + this.f_93620_ + 200), (int)(this.guiTop + this.f_93621_ - 8), (float)0.5f, (int)0xFFFFFF);
        }
        if (this.initiatorName != null) {
            String initiatorString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.owner", (Object[])new Object[]{this.initiatorName});
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)fontRenderer, (String)initiatorString, (int)(this.guiLeft + this.f_93620_ - 4), (int)(this.guiTop + this.f_93621_ - 14), (float)0.5f, (int)0xFFFFFF);
        }
        this.drawGuiContainerLayer(matrixStack, this.guiLeft, this.guiTop, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND, partialTicks, mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
    }

    public void drawGuiContainerForegroundLayer(PoseStack matrixStack, int mouseX, int mouseY) {
        this.drawGuiContainerLayer(matrixStack, 0, 0, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND, 0.0f, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.scrollBar.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        return this.scrollBar.m_7979_(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public static List<Element> getElements(ITerminalCraftingPlanFlat<?> craftingPlan) {
        ArrayList elements = Lists.newArrayList();
        for (ITerminalCraftingPlanFlat.IEntry entry : craftingPlan.getEntries()) {
            GuiCraftingPlanFlat.addElements(entry, elements);
        }
        return elements;
    }

    protected static void addElements(ITerminalCraftingPlanFlat.IEntry craftingPlan, List<Element> elements) {
        elements.add(new Element(craftingPlan.getInstance(), craftingPlan.getQuantityInStorage(), craftingPlan.getQuantityToCraft(), craftingPlan.getQuantityCrafting(), craftingPlan.getQuantityMissing()));
    }

    public boolean isValid() {
        return this.valid;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public static class Element {
        private final IPrototypedIngredient<?, ?> instance;
        private final long storageQuantity;
        private final long toCraftQuantity;
        private final long craftingQuantity;
        private final long missingQuantity;

        public Element(IPrototypedIngredient<?, ?> instance, long storageQuantity, long toCraftQuantity, long craftingQuantity, long missingQuantity) {
            this.instance = instance;
            this.storageQuantity = storageQuantity;
            this.toCraftQuantity = toCraftQuantity;
            this.craftingQuantity = craftingQuantity;
            this.missingQuantity = missingQuantity;
        }

        public IPrototypedIngredient<?, ?> getInstance() {
            return this.instance;
        }

        public long getStorageQuantity() {
            return this.storageQuantity;
        }

        public long getToCraftQuantity() {
            return this.toCraftQuantity;
        }

        public long getCraftingQuantity() {
            return this.craftingQuantity;
        }

        public long getMissingQuantity() {
            return this.missingQuantity;
        }

        public int getColor() {
            if (this.getMissingQuantity() > 0L) {
                return Helpers.RGBAToInt((int)250, (int)10, (int)13, (int)150);
            }
            if (this.getCraftingQuantity() > 0L) {
                return Helpers.RGBAToInt((int)43, (int)174, (int)231, (int)150);
            }
            if (this.getToCraftQuantity() > 0L) {
                return Helpers.RGBAToInt((int)243, (int)245, (int)150, (int)150);
            }
            return Helpers.RGBAToInt((int)43, (int)231, (int)47, (int)150);
        }
    }
}

