/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container.component;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.lwjgl.opengl.GL11;

public class GuiCraftingPlan
extends AbstractWidget {
    public static final int ELEMENT_WIDTH = 221;
    private static final int ELEMENT_HEIGHT = 16;
    private static final int ELEMENT_HEIGHT_TOTAL = 18;
    protected static final int TICK_DELAY = 30;
    private final AbstractContainerScreen parentGui;
    private final int guiLeft;
    private final int guiTop;
    private final List<Element> elements;
    private final List<Element> visibleElements;
    private final boolean valid;
    private final WidgetScrollBar scrollBar;
    private final String label;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;
    private int firstRow;

    public GuiCraftingPlan(AbstractContainerScreen parentGui, ITerminalCraftingPlan<?> craftingPlan, int guiLeft, int guiTop, int x, int y, int visibleRows) {
        super(x, y, 0, 0, (Component)Component.m_237113_((String)""));
        this.parentGui = parentGui;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.elements = GuiCraftingPlan.getElements(craftingPlan);
        this.visibleElements = Lists.newArrayList(this.elements);
        this.valid = craftingPlan.getStatus().isValid();
        this.scrollBar = new WidgetScrollBar(guiLeft + x + 227, guiTop + y + 0, 178, (Component)Component.m_237115_((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, visibleRows);
        this.scrollBar.setTotalRows(this.visibleElements.size());
        this.label = L10NHelpers.localize((String)craftingPlan.getUnlocalizedLabel(), (Object[])new Object[0]);
        this.tickDuration = craftingPlan.getTickDuration();
        this.channel = craftingPlan.getChannel();
        this.initiatorName = craftingPlan.getInitiatorName();
    }

    public void inheritVisualizationState(GuiCraftingPlan guiCraftingPlan) {
        float lastScroll = guiCraftingPlan.scrollBar.getCurrentScroll();
        this.scrollBar.scrollTo(lastScroll);
        IntOpenHashSet disabledElementIds = new IntOpenHashSet();
        for (Element element : guiCraftingPlan.elements) {
            if (element.isEnabled()) continue;
            disabledElementIds.add(element.getId());
        }
        for (Element element : this.elements) {
            if (!disabledElementIds.contains(element.getId())) continue;
            element.setEnabled(false);
        }
        this.refreshList();
    }

    protected void refreshList() {
        this.visibleElements.clear();
        GuiCraftingPlan.addActiveElements(this.elements.get(0), this.visibleElements);
        this.scrollBar.setTotalRows(this.visibleElements.size());
    }

    protected static void addActiveElements(Element root, List<Element> elements) {
        if (root.isEnabled()) {
            elements.add(root);
            for (Element child : root.getChildren()) {
                GuiCraftingPlan.addActiveElements(child, elements);
            }
        }
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = Math.max(0, firstRow);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    protected List<Element> getVisibleElements() {
        return this.visibleElements.subList(this.firstRow, Math.min(this.visibleElements.size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected int getAbsoluteElementIndent(Element element) {
        return element.getIndent() * 8;
    }

    public void drawGuiContainerLayer(PoseStack matrixStack, int guiLeft, int guiTop, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            this.drawElement(matrixStack, element, this.getAbsoluteElementIndent(element), guiLeft + this.f_93620_, guiTop + this.f_93621_ + offsetY, 221, 16, layer, partialTick, mouseX, mouseY);
            offsetY += 18;
        }
    }

    protected int getTick() {
        return (int)Minecraft.m_91087_().f_91073_.m_46467_() / 30;
    }

    private void drawElement(PoseStack matrixStack, Element element, int indent, int x, int y, int width, int height, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            GuiCraftingPlan.m_93172_((PoseStack)matrixStack, (int)x, (int)y, (int)(x + width), (int)(y + height + 1), (int)element.getColor());
        }
        int xOriginal = x;
        x += indent;
        if (!element.getChildren().isEmpty() && layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            Image image = element.getChildren().get(0).isEnabled() ? Images.ARROW_DOWN : Images.ARROW_RIGHT;
            image.draw((GuiComponent)this, matrixStack, x, y);
        }
        x += 16;
        int tick = this.getTick();
        for (List<IPrototypedIngredient<?, ?>> alternatives : element.getOutputs()) {
            IPrototypedIngredient<?, ?> output = alternatives.get(tick % alternatives.size());
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            int finalX = x;
            int finalY = y;
            ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY).ifPresent(h -> h.drawInstance(matrixStack, output.getPrototype(), quantity, GuiHelpers.quantityToScaledString((long)quantity), this.parentGui, layer, partialTick, finalX, finalY, mouseX, mouseY, null));
            x += GuiHelpers.SLOT_SIZE_INNER;
        }
        x = xOriginal + width - 50;
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            int moved = 0;
            if (element.getStorageQuantity() > 0L) {
                GuiCraftingPlan.renderItem(RenderSystem.m_157191_(), new ItemStack((ItemLike)Blocks.f_50087_), x, y, 0.45f);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.stored", (Object[])new Object[]{element.getStorageQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
                y += 8;
                ++moved;
            }
            if (element.getCraftQuantity() > 0L) {
                GuiCraftingPlan.renderItem(RenderSystem.m_157191_(), new ItemStack((ItemLike)Blocks.f_50091_), x, y, 0.45f);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.crafting", (Object[])new Object[]{element.getCraftQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
                y += 8;
                ++moved;
            }
            if (element.getMissingQuantity() > 0L) {
                if (moved == 2) {
                    y -= 16;
                    x -= 44;
                }
                GuiCraftingPlan.renderItem(RenderSystem.m_157191_(), new ItemStack((ItemLike)Blocks.f_50375_), x, y, 0.45f);
                RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.missing", (Object[])new Object[]{element.getMissingQuantity()}), (int)(x + 9), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GuiHelpers.renderTooltipOptional((AbstractContainerScreen)this.parentGui, (PoseStack)matrixStack, (int)x, (int)y, (int)50, (int)GuiHelpers.SLOT_SIZE, (int)mouseX, (int)mouseY, () -> {
                String unlocalizedName = "gui.integratedterminals.craftingplan.status." + element.getStatus().name().toLowerCase(Locale.ENGLISH);
                return Optional.of(Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)unlocalizedName), Component.m_237115_((String)(unlocalizedName + ".desc"))}));
            });
        }
    }

    protected static void renderItem(PoseStack poseStack, ItemStack itemStack, int x, int y, float scale) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 0.0);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.m_157182_();
        RenderItemExtendedSlotCount renderItem = RenderItemExtendedSlotCount.getInstance();
        GlStateManager.m_84525_();
        GlStateManager.m_84328_((int)770, (int)771);
        Lighting.m_84931_();
        GlStateManager.m_84513_();
        GL11.glEnable((int)2929);
        renderItem.m_115203_(itemStack, 0, 0);
        renderItem.m_115174_(Minecraft.m_91087_().f_91062_, itemStack, 0, 0, "");
        Lighting.m_84930_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static String getDurationString(long tickDuration) {
        long durationMs = tickDuration * 1000L / 20L;
        return L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.duration", (Object[])new Object[]{DurationFormatUtils.formatDuration((long)durationMs, (String)"H:mm:ss", (boolean)true)});
    }

    public void drawGuiContainerBackgroundLayer(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        GuiCraftingPlan.m_93208_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)this.label, (int)(this.guiLeft + this.f_93620_ + 110 + 8), (int)(this.guiTop + this.f_93621_ - 13), (int)0xFFFFFF);
        if (this.tickDuration >= 0L) {
            String durationString = GuiCraftingPlan.getDurationString(this.tickDuration);
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)fontRenderer, (String)durationString, (int)(this.guiLeft + this.f_93620_ + 200), (int)(this.guiTop + this.f_93621_ - 14), (float)0.5f, (int)0xFFFFFF);
        }
        if (this.channel != -1) {
            String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{this.channel});
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)fontRenderer, (String)channelString, (int)(this.guiLeft + this.f_93620_ + 200), (int)(this.guiTop + this.f_93621_ - 8), (float)0.5f, (int)0xFFFFFF);
        }
        if (this.initiatorName != null) {
            String initiatorString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.owner", (Object[])new Object[]{this.initiatorName});
            RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)fontRenderer, (String)initiatorString, (int)(this.guiLeft + this.f_93620_ - 4), (int)(this.guiTop + this.f_93621_ - 14), (float)0.5f, (int)0xFFFFFF);
        }
        this.drawGuiContainerLayer(matrixStack, this.guiLeft, this.guiTop, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND, partialTicks, mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
    }

    public void drawGuiContainerForegroundLayer(PoseStack matrixStack, int mouseX, int mouseY) {
        this.drawGuiContainerLayer(matrixStack, 0, 0, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND, 0.0f, mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return this.scrollBar.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        return this.scrollBar.m_7979_(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int offsetY = 0;
        for (Element element : this.getVisibleElements()) {
            int x = this.guiLeft + this.f_93620_ + this.getAbsoluteElementIndent(element);
            int y = this.guiTop + this.f_93621_ + offsetY;
            offsetY += 18;
            if (!RenderHelpers.isPointInRegion((Rectangle)new Rectangle(x, y, 221, 16), (Point)new Point((int)mouseX, (int)mouseY))) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            for (Element child : element.getChildren()) {
                child.setEnabled(!child.isEnabled());
            }
            this.refreshList();
            return true;
        }
        return false;
    }

    public static List<Element> getElements(ITerminalCraftingPlan<?> craftingPlan) {
        ArrayList elements = Lists.newArrayList();
        GuiCraftingPlan.addElements(null, 0, craftingPlan, elements);
        return elements;
    }

    protected static void addElements(@Nullable Element parent, int indent, ITerminalCraftingPlan<?> craftingPlan, List<Element> elements) {
        boolean valid = craftingPlan.getStatus().isValid() || !craftingPlan.getStorageIngredients().isEmpty() || !craftingPlan.getDependencies().isEmpty();
        int elementId = Objects.hash(craftingPlan.getId()) * 100;
        Element currentElement = new Element(elementId++, indent, craftingPlan.getOutputs().stream().map(Collections::singletonList).collect(Collectors.toList()), 0L, valid ? craftingPlan.getCraftingQuantity() : 0L, valid ? 0L : craftingPlan.getCraftingQuantity(), craftingPlan.getStatus().getColor(), craftingPlan.getStatus());
        if (parent != null) {
            parent.addChild(currentElement);
        }
        elements.add(currentElement);
        if (craftingPlan.getStatus() == TerminalCraftingJobStatus.PENDING_INPUTS) {
            for (List<IPrototypedIngredient<?, ?>> list : craftingPlan.getLastMissingIngredients()) {
                List<List<IPrototypedIngredient<?, ?>>> outputs = Collections.singletonList(list.stream().map(prototypedIngredient -> {
                    IIngredientMatcher matcher = prototypedIngredient.getComponent().getMatcher();
                    Object instance = matcher.withQuantity(prototypedIngredient.getPrototype(), matcher.getQuantity(prototypedIngredient.getPrototype()) * craftingPlan.getCraftingQuantity());
                    return new PrototypedIngredient(prototypedIngredient.getComponent(), instance, prototypedIngredient.getCondition());
                }).collect(Collectors.toList()));
                elements.add(currentElement.addChild(new Element(elementId++, indent + 1, outputs, 0L, 0L, craftingPlan.getCraftingQuantity(), TerminalCraftingJobStatus.INVALID.getColor(), TerminalCraftingJobStatus.INVALID)));
            }
        } else if (craftingPlan.getStatus() != TerminalCraftingJobStatus.CRAFTING) {
            for (IPrototypedIngredient iPrototypedIngredient : craftingPlan.getStorageIngredients()) {
                elements.add(currentElement.addChild(new Element(elementId++, indent + 1, Collections.singletonList(Collections.singletonList(iPrototypedIngredient)), iPrototypedIngredient.getComponent().getMatcher().getQuantity(iPrototypedIngredient.getPrototype()), 0L, 0L, TerminalCraftingJobStatus.FINISHED.getColor(), TerminalCraftingJobStatus.FINISHED)));
            }
        }
        for (ITerminalCraftingPlan iTerminalCraftingPlan : craftingPlan.getDependencies()) {
            GuiCraftingPlan.addElements(currentElement, indent + 1, iTerminalCraftingPlan, elements);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public static class Element {
        private final int id;
        private final int indent;
        private final List<List<IPrototypedIngredient<?, ?>>> outputs;
        private final long storageQuantity;
        private final long craftQuantity;
        private final long missingQuantity;
        private final int color;
        private final List<Element> children;
        private final TerminalCraftingJobStatus status;
        private boolean enabled;

        public Element(int id, int indent, List<List<IPrototypedIngredient<?, ?>>> outputs, long storageQuantity, long craftQuantity, long missingQuantity, int color, TerminalCraftingJobStatus status) {
            this.id = id;
            this.indent = indent;
            this.outputs = outputs;
            this.storageQuantity = storageQuantity;
            this.craftQuantity = craftQuantity;
            this.missingQuantity = missingQuantity;
            this.color = color;
            this.status = status;
            this.children = Lists.newArrayList();
            this.enabled = true;
        }

        public int getId() {
            return this.id;
        }

        public int getIndent() {
            return this.indent;
        }

        public List<List<IPrototypedIngredient<?, ?>>> getOutputs() {
            return this.outputs;
        }

        public long getStorageQuantity() {
            return this.storageQuantity;
        }

        public long getCraftQuantity() {
            return this.craftQuantity;
        }

        public long getMissingQuantity() {
            return this.missingQuantity;
        }

        public int getColor() {
            return this.color;
        }

        public Element addChild(Element element) {
            this.children.add(element);
            return element;
        }

        public List<Element> getChildren() {
            return this.children;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public TerminalCraftingJobStatus getStatus() {
            return this.status;
        }
    }
}

