/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;
import org.zeith.hammerlib.tiles.tooltip.own.inf.TooltipInfoProgressBar;
import org.zeith.hammerlib.tiles.tooltip.own.inf.TooltipInfoSpacing;
import org.zeith.hammerlib.tiles.tooltip.own.inf.TooltipInfoStack;
import org.zeith.hammerlib.tiles.tooltip.own.inf.TooltipInfoText;
import org.zeith.hammerlib.tiles.tooltip.own.inf.TooltipInfoTexture;

public interface ITooltip {
    public ITooltip add(IRenderableInfo var1);

    default public ITooltip addText(Component component) {
        return this.add(new TooltipInfoText(component));
    }

    default public ITooltip addSpacing(float width, float height) {
        return this.add(new TooltipInfoSpacing(width, height));
    }

    default public ITooltip addTexture(ResourceLocation texture, float width, float height, int rgba) {
        return this.add(new TooltipInfoTexture(texture, width, height, rgba));
    }

    default public ITooltip addTexture(ResourceLocation texture, float width, float height) {
        return this.add(new TooltipInfoTexture(texture, width, height, -1));
    }

    default public ITooltip addStack(ItemStack stack, float width, float height) {
        return this.add(new TooltipInfoStack(stack, width, height));
    }

    default public ITooltip addProgressBar(ProgressBar bar) {
        return this.add(new TooltipInfoProgressBar(bar));
    }

    public ITooltip newLine();

    @Nullable
    public Level getWorld();

    @Nullable
    public BlockPos getPos();

    @Nullable
    public Entity getEntity();

    public Player getPlayer();

    public Direction getSideHit();

    public Vec3 getHitVec();

    public float getWidth();

    public float getHeight();

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack var1, float var2, float var3, float var4);

    public void reset();
}

