/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.mixins.client;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.zeith.hammerlib.api.client.IEmissivePlayerInfo;
import org.zeith.hammerlib.client.render.entity.player.EmissiveSkinHelper;
import org.zeith.hammerlib.client.texture.HttpTextureDownloader;
import org.zeith.hammerlib.client.utils.FXUtils;

@Mixin(value={PlayerInfo.class})
@Implements(value={@Interface(iface=IEmissivePlayerInfo.class, prefix="IEPI$")})
public abstract class PlayerInfoMixin {
    private boolean pendingEmissiveTextures;
    @Shadow
    @Final
    private GameProfile f_105298_;
    private final Map<MinecraftProfileTexture.Type, ResourceLocation> emissiveTextureLocations = Maps.newEnumMap(MinecraftProfileTexture.Type.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerEmissiveTextures() {
        if (this.pendingEmissiveTextures) {
            return;
        }
        PlayerInfoMixin playerInfoMixin = this;
        synchronized (playerInfoMixin) {
            if (!this.pendingEmissiveTextures) {
                this.pendingEmissiveTextures = true;
                Util.m_183991_().execute(() -> {
                    GameProfile gp = EmissiveSkinHelper.adaptGameProfileToEmissiveTextures(this.f_105298_);
                    String gpid = gp.getId().toString();
                    HashMap<MinecraftProfileTexture.Type, String> texturesToDownload = new HashMap<MinecraftProfileTexture.Type, String>();
                    for (MinecraftProfileTexture.Type type : EmissiveSkinHelper.findEmissiveTextureTypes(gpid)) {
                        String url = EmissiveSkinHelper.getEmissiveRequestURL(gpid, type);
                        texturesToDownload.put(type, url);
                    }
                    Minecraft.m_91087_().execute(() -> RenderSystem.m_69879_(() -> {
                        for (Map.Entry entry : texturesToDownload.entrySet()) {
                            ResourceLocation texture = FXUtils.urlToTexturePath((String)entry.getValue());
                            MinecraftProfileTexture.Type type = (MinecraftProfileTexture.Type)entry.getKey();
                            HttpTextureDownloader.create(texture, (String)entry.getValue(), () -> {
                                Map<MinecraftProfileTexture.Type, ResourceLocation> map = this.emissiveTextureLocations;
                                synchronized (map) {
                                    this.emissiveTextureLocations.put(type, texture);
                                }
                            });
                        }
                    }));
                });
            }
        }
    }

    @Nullable
    public ResourceLocation IEPI$getEmissiveSkinLocation() {
        this.registerEmissiveTextures();
        return this.emissiveTextureLocations.get(MinecraftProfileTexture.Type.SKIN);
    }

    @Nullable
    public ResourceLocation IEPI$getEmissiveCapeLocation() {
        this.registerEmissiveTextures();
        return this.emissiveTextureLocations.get(MinecraftProfileTexture.Type.CAPE);
    }

    @Nullable
    public ResourceLocation IEPI$getEmissiveElytraLocation() {
        this.registerEmissiveTextures();
        return this.emissiveTextureLocations.get(MinecraftProfileTexture.Type.ELYTRA);
    }
}

