/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.inv;

import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SimpleInventory
implements IItemHandlerModifiable,
Iterable<ItemStack>,
INBTSerializable<ListTag>,
Container {
    public final NonNullList<ItemStack> items;
    public int stackSizeLimit = 64;
    public ToIntFunction<Integer> getSlotLimit = s -> this.stackSizeLimit;
    public BiPredicate<Integer, ItemStack> isStackValid = (i, s) -> true;

    public SimpleInventory(int slots) {
        this.items = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
    }

    public int getSlots() {
        return this.items.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.setStackInSlot(slot, copy);
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.setStackInSlot(slot, copy);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.setStackInSlot(slot, stack.m_41620_(m));
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        return stack.m_41620_(amount);
    }

    public int getSlotLimit(int slot) {
        return this.getSlotLimit.applyAsInt(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isStackValid.test(slot, stack);
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return this.isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
        }
    }

    public void writeToNBT(CompoundTag nbt, String label) {
        nbt.m_128365_(label, (Tag)this.writeToNBT(new ListTag()));
    }

    public void readFromNBT(CompoundTag nbt, String label) {
        this.readFromNBT(nbt.m_128437_(label, 10));
    }

    public ListTag writeToNBT(ListTag nbt) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag tag = stack.serializeNBT();
            tag.m_128405_("Slot", i);
            nbt.add((Object)tag);
        }
        return nbt;
    }

    public void readFromNBT(ListTag nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag = nbt.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag);
            short slot = tag.m_128448_("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set((int)slot, (Object)stack);
        }
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.items.iterator();
    }

    public Stream<ItemStack> stream() {
        return this.items.stream();
    }

    public ListTag serializeNBT() {
        return this.writeToNBT(new ListTag());
    }

    public void deserializeNBT(ListTag nbt) {
        this.readFromNBT(nbt);
    }

    public int m_6643_() {
        return this.getSlots();
    }

    public boolean m_7983_() {
        for (ItemStack e : this) {
            if (e.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        ItemStack stack = (ItemStack)this.items.get(slot);
        if (!stack.m_41619_()) {
            return stack.m_41620_(count);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(slot, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int slot, ItemStack item) {
        this.items.set(slot, (Object)item);
        if (!item.m_41619_() && item.m_41613_() > this.m_6893_()) {
            item.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
    }
}

