/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.actions.impl;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.zeith.hammerlib.abstractions.actions.ContinuousLevelAction;
import org.zeith.hammerlib.abstractions.actions.ILevelActionType;
import org.zeith.hammerlib.abstractions.actions.RunnableLevelAction;
import org.zeith.hammerlib.core.init.LevelActionTypesHL;
import org.zeith.hammerlib.util.java.Cast;

public class DelayedLevelAction
extends ContinuousLevelAction {
    protected final RunnableLevelAction action;
    protected int delay;

    public DelayedLevelAction(int delay, RunnableLevelAction action) {
        this(LevelActionTypesHL.DELAYED_TYPE, delay, action);
    }

    public DelayedLevelAction(ILevelActionType type, int delay, RunnableLevelAction action) {
        super(type);
        this.delay = delay;
        this.action = action;
    }

    public DelayedLevelAction(ILevelActionType type, Level level, CompoundTag tag) {
        this(type, tag.m_128451_("Delay"), DelayedLevelAction.read(level, tag.m_128469_("Run")).map(Cast.convertTo(RunnableLevelAction.class)).orElse(null));
    }

    @Override
    public DelayedLevelAction delay(int delay) {
        this.delay += delay;
        return this;
    }

    @Override
    public boolean isDone() {
        ContinuousLevelAction c;
        RunnableLevelAction runnableLevelAction;
        return this.action == null || this.delay < 0 && (!((runnableLevelAction = this.action) instanceof ContinuousLevelAction) || (c = (ContinuousLevelAction)runnableLevelAction).isDone());
    }

    @Override
    public void run(ServerLevel level) {
        --this.delay;
        if (this.delay < 0) {
            this.action.run(level);
        }
    }

    @Override
    public CompoundTag write(Level level) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Delay", this.delay);
        tag.m_128365_("Run", (Tag)DelayedLevelAction.write(level, this.action));
        return tag;
    }
}

