/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import com.mojang.math.Vector3f;
import dev.latvian.mods.rhino.Undefined;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MaterialColor;

public record MapColorHelper(int id, String name, MaterialColor color, Vector3f rgb) implements Function<BlockState, MaterialColor>
{
    public static final Map<String, MapColorHelper> NAME_MAP = new HashMap<String, MapColorHelper>(64);
    public static final Map<Integer, MapColorHelper> ID_MAP = new HashMap<Integer, MapColorHelper>(64);
    public static final MapColorHelper NONE = MapColorHelper.add("none", MaterialColor.f_76398_);

    private static MapColorHelper add(String id, MaterialColor color) {
        float r = (float)(color.f_76396_ >> 16 & 0xFF) / 255.0f;
        float g = (float)(color.f_76396_ >> 8 & 0xFF) / 255.0f;
        float b = (float)(color.f_76396_ & 0xFF) / 255.0f;
        MapColorHelper helper = new MapColorHelper(color.f_76397_, id, color, new Vector3f(r, g, b));
        NAME_MAP.put(id, helper);
        ID_MAP.put(color.f_76397_, helper);
        return helper;
    }

    public static MaterialColor of(Object o) {
        if (o == null || Undefined.isUndefined((Object)o)) {
            return MaterialColor.f_76398_;
        }
        if (o instanceof MaterialColor) {
            MaterialColor c = (MaterialColor)o;
            return c;
        }
        if (o instanceof CharSequence) {
            CharSequence s = (CharSequence)o;
            if (s.isEmpty()) {
                return MaterialColor.f_76398_;
            }
            if (s.charAt(0) == '#') {
                return MapColorHelper.findClosest((int)Integer.decode((String)s.toString()).intValue()).color;
            }
            return MapColorHelper.NAME_MAP.getOrDefault((Object)s.toString().toLowerCase(), (MapColorHelper)MapColorHelper.NONE).color;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return MapColorHelper.findClosest((int)n.intValue()).color;
        }
        if (o instanceof DyeColor) {
            DyeColor c = (DyeColor)o;
            return c.m_41069_();
        }
        return MaterialColor.f_76398_;
    }

    public static MapColorHelper reverse(MaterialColor c) {
        return ID_MAP.getOrDefault(c.f_76397_, NONE);
    }

    public static MapColorHelper findClosest(int rgbi) {
        Vector3f rgb = new Vector3f((float)(rgbi >> 16 & 0xFF) / 255.0f, (float)(rgbi >> 8 & 0xFF) / 255.0f, (float)(rgbi & 0xFF) / 255.0f);
        MapColorHelper closest = null;
        float lastDist = Float.MAX_VALUE;
        for (MapColorHelper helper : NAME_MAP.values()) {
            float dist;
            if (helper.color == MaterialColor.f_76398_ || !((dist = MapColorHelper.distSq(helper.rgb, rgb)) < lastDist)) continue;
            closest = helper;
            lastDist = dist;
        }
        return closest == null ? NONE : closest;
    }

    private static float distSq(Vector3f a, Vector3f b) {
        return (a.m_122239_() - b.m_122239_()) * (a.m_122239_() - b.m_122239_()) + (a.m_122260_() - b.m_122260_()) * (a.m_122260_() - b.m_122260_()) + (a.m_122269_() - b.m_122269_()) * (a.m_122269_() - b.m_122269_());
    }

    @Override
    public MaterialColor apply(BlockState blockState) {
        return this.color;
    }

    static {
        MapColorHelper.add("grass", MaterialColor.f_76399_);
        MapColorHelper.add("sand", MaterialColor.f_76400_);
        MapColorHelper.add("wool", MaterialColor.f_76401_);
        MapColorHelper.add("fire", MaterialColor.f_76402_);
        MapColorHelper.add("ice", MaterialColor.f_76403_);
        MapColorHelper.add("metal", MaterialColor.f_76404_);
        MapColorHelper.add("plant", MaterialColor.f_76405_);
        MapColorHelper.add("snow", MaterialColor.f_76406_);
        MapColorHelper.add("clay", MaterialColor.f_76407_);
        MapColorHelper.add("dirt", MaterialColor.f_76408_);
        MapColorHelper.add("stone", MaterialColor.f_76409_);
        MapColorHelper.add("water", MaterialColor.f_76410_);
        MapColorHelper.add("wood", MaterialColor.f_76411_);
        MapColorHelper.add("quartz", MaterialColor.f_76412_);
        MapColorHelper.add("color_orange", MaterialColor.f_76413_);
        MapColorHelper.add("color_magenta", MaterialColor.f_76414_);
        MapColorHelper.add("color_light_blue", MaterialColor.f_76415_);
        MapColorHelper.add("color_yellow", MaterialColor.f_76416_);
        MapColorHelper.add("color_light_green", MaterialColor.f_76417_);
        MapColorHelper.add("color_pink", MaterialColor.f_76418_);
        MapColorHelper.add("color_gray", MaterialColor.f_76419_);
        MapColorHelper.add("color_light_gray", MaterialColor.f_76420_);
        MapColorHelper.add("color_cyan", MaterialColor.f_76421_);
        MapColorHelper.add("color_purple", MaterialColor.f_76422_);
        MapColorHelper.add("color_blue", MaterialColor.f_76361_);
        MapColorHelper.add("color_brown", MaterialColor.f_76362_);
        MapColorHelper.add("color_green", MaterialColor.f_76363_);
        MapColorHelper.add("color_red", MaterialColor.f_76364_);
        MapColorHelper.add("color_black", MaterialColor.f_76365_);
        MapColorHelper.add("gold", MaterialColor.f_76366_);
        MapColorHelper.add("diamond", MaterialColor.f_76367_);
        MapColorHelper.add("lapis", MaterialColor.f_76368_);
        MapColorHelper.add("emerald", MaterialColor.f_76369_);
        MapColorHelper.add("podzol", MaterialColor.f_76370_);
        MapColorHelper.add("nether", MaterialColor.f_76371_);
        MapColorHelper.add("terracotta_white", MaterialColor.f_76372_);
        MapColorHelper.add("terracotta_orange", MaterialColor.f_76373_);
        MapColorHelper.add("terracotta_magenta", MaterialColor.f_76374_);
        MapColorHelper.add("terracotta_light_blue", MaterialColor.f_76375_);
        MapColorHelper.add("terracotta_yellow", MaterialColor.f_76376_);
        MapColorHelper.add("terracotta_light_green", MaterialColor.f_76377_);
        MapColorHelper.add("terracotta_pink", MaterialColor.f_76378_);
        MapColorHelper.add("terracotta_gray", MaterialColor.f_76379_);
        MapColorHelper.add("terracotta_light_gray", MaterialColor.f_76380_);
        MapColorHelper.add("terracotta_cyan", MaterialColor.f_76381_);
        MapColorHelper.add("terracotta_purple", MaterialColor.f_76382_);
        MapColorHelper.add("terracotta_blue", MaterialColor.f_76383_);
        MapColorHelper.add("terracotta_brown", MaterialColor.f_76384_);
        MapColorHelper.add("terracotta_green", MaterialColor.f_76385_);
        MapColorHelper.add("terracotta_red", MaterialColor.f_76386_);
        MapColorHelper.add("terracotta_black", MaterialColor.f_76388_);
        MapColorHelper.add("crimson_nylium", MaterialColor.f_76389_);
        MapColorHelper.add("crimson_stem", MaterialColor.f_76390_);
        MapColorHelper.add("crimson_hyphae", MaterialColor.f_76391_);
        MapColorHelper.add("warped_nylium", MaterialColor.f_76392_);
        MapColorHelper.add("warped_stem", MaterialColor.f_76393_);
        MapColorHelper.add("warped_hyphae", MaterialColor.f_76394_);
        MapColorHelper.add("warped_wart_block", MaterialColor.f_76395_);
        MapColorHelper.add("deepslate", MaterialColor.f_164534_);
        MapColorHelper.add("raw_iron", MaterialColor.f_164535_);
        MapColorHelper.add("glow_lichen", MaterialColor.f_164536_);
    }
}

