/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.IIngredientGrid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class DeleteItemInputHandler
implements IUserInputHandler {
    private final IIngredientGrid ingredientGrid;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;
    private final IIngredientManager ingredientManager;

    public DeleteItemInputHandler(IIngredientGrid ingredientGrid, IWorldConfig worldConfig, IClientConfig clientConfig, IConnectionToServer serverConnection, IIngredientManager ingredientManager) {
        this.ingredientGrid = ingredientGrid;
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput userInput, IInternalKeyMappings keyBindings) {
        double mouseY;
        if (!userInput.is(keyBindings.getLeftClick())) {
            return Optional.empty();
        }
        double mouseX = userInput.getMouseX();
        if (!this.ingredientGrid.isMouseOver(mouseX, mouseY = userInput.getMouseY())) {
            return Optional.empty();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            return Optional.empty();
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return Optional.empty();
        }
        ItemStack itemStack = player.f_36096_.m_142621_();
        if (itemStack.m_41619_()) {
            return Optional.empty();
        }
        if (!userInput.isSimulate()) {
            player.f_36096_.m_142503_(ItemStack.f_41583_);
            PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
            this.serverConnection.sendPacketToServer(packet);
        }
        return Optional.of(this);
    }

    public void drawTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        JeiTooltip tooltip = new JeiTooltip();
        tooltip.add((Component)Component.m_237115_((String)"jei.tooltip.delete.item"));
        tooltip.draw(poseStack, mouseX, mouseY);
    }

    public boolean shouldDeleteItemOnClick(Minecraft minecraft, double mouseX, double mouseY) {
        if (!this.worldConfig.isCheatItemsEnabled() || !this.serverConnection.isJeiOnServer()) {
            return false;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.f_36096_.m_142621_();
        if (itemStack.m_41619_()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP) {
            return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY).findFirst().map(c -> c.getCheatItemStack(this.ingredientManager)).map(i -> !ServerCommandUtil.canStack(itemStack, i)).orElse(true);
        }
        return true;
    }
}

