/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.Registries;
import com.gizmo.luggage.entity.AbstractLuggage;
import com.gizmo.luggage.entity.ai.LuggageFollowOwnerGoal;
import com.gizmo.luggage.entity.ai.LuggagePickupItemGoal;
import com.gizmo.luggage.network.LuggageNetworkHandler;
import com.gizmo.luggage.network.OpenLuggageScreenPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Luggage
extends AbstractLuggage
implements ContainerListener {
    private static final EntityDataAccessor<Boolean> EXTENDED = SynchedEntityData.m_135353_(Luggage.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final String INVENTORY_TAG = "Inventory";
    public static final String EXTENDED_TAG = "Extended";
    private SimpleContainer inventory;
    private LazyOptional<?> itemHandler = null;
    private int fetchCooldown = 0;
    private boolean tryingToFetchItem;
    private boolean isInventoryOpen;

    public Luggage(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.createInventory();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LuggagePickupItemGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LuggageFollowOwnerGoal(this, 1.1, 7.0f, 1.0f){

            @Override
            public boolean m_8036_() {
                if (super.m_8036_()) {
                    List items = Luggage.this.m_9236_().m_6443_(ItemEntity.class, Luggage.this.m_20191_().m_82400_(8.0), item -> (item.m_20096_() || item.m_20069_()) && Luggage.this.m_142582_((Entity)item) && Luggage.this.getInventory().m_19183_(item.m_32055_()) && item.m_32055_().m_41720_().m_142095_());
                    if (Luggage.this.m_21825_() || Luggage.this.isTryingToFetchItem()) {
                        return false;
                    }
                    ArrayList<ItemEntity> revisedItems = new ArrayList<ItemEntity>();
                    if (!items.isEmpty()) {
                        for (ItemEntity item2 : items) {
                            Path toPath = Luggage.this.f_21344_.m_6570_((Entity)item2, 1);
                            if (toPath == null || !toPath.m_77403_()) continue;
                            revisedItems.add(item2);
                        }
                    }
                    return revisedItems.isEmpty();
                }
                return false;
            }
        });
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(EXTENDED, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ListTag listtag = new ListTag();
        tag.m_128379_(EXTENDED_TAG, this.hasExtendedInventory());
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.m_128365_("Items", (Tag)listtag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        ListTag listtag = tag.m_128437_("Items", 10);
        this.setExtendedInventory(tag.m_128471_(EXTENDED_TAG));
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    private ItemStack convertToItem() {
        Component nameTag;
        ItemStack luggageItem = new ItemStack((ItemLike)Registries.ItemRegistry.LUGGAGE.get());
        CompoundTag tag = new CompoundTag();
        if (this.hasExtendedInventory()) {
            tag.m_128379_(EXTENDED_TAG, this.hasExtendedInventory());
        }
        if (!this.inventory.m_7983_()) {
            tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.m_7927_());
        }
        if (!tag.m_128456_()) {
            luggageItem.m_41751_(tag);
        }
        if ((nameTag = this.m_7770_()) != null && !nameTag.getString().isEmpty()) {
            luggageItem.m_41714_(nameTag);
        }
        return luggageItem;
    }

    public void restoreFromStack(@NotNull ItemStack stack) {
        if (!stack.m_150930_((Item)Registries.ItemRegistry.LUGGAGE.get())) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(EXTENDED_TAG)) {
            this.setExtendedInventory(tag.m_128471_(EXTENDED_TAG));
        }
        if (tag != null && tag.m_128441_(INVENTORY_TAG)) {
            this.inventory.m_7797_(tag.m_128437_(INVENTORY_TAG, 10));
            if (this.inventory.m_6643_() > 27) {
                this.setExtendedInventory(true);
            }
        }
        if (stack.m_41788_()) {
            this.m_6593_(stack.m_41786_());
        }
        this.fetchCooldown = 20;
    }

    private void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.hasExtendedInventory() ? 54 : 27);
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean hasExtendedInventory() {
        return (Boolean)this.m_20088_().m_135370_(EXTENDED);
    }

    public void setExtendedInventory(boolean extended) {
        this.m_20088_().m_135381_(EXTENDED, (Object)extended);
        this.createInventory();
    }

    public void m_5757_(Container container) {
    }

    public boolean hasInventoryChanged(Container container) {
        return this.inventory != container;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean isTryingToFetchItem() {
        return this.tryingToFetchItem;
    }

    public void setTryingToFetchItem(boolean fetch) {
        this.tryingToFetchItem = fetch;
    }

    public int getFetchCooldown() {
        return this.fetchCooldown;
    }

    public void setFetchCooldown(int cooldown) {
        this.fetchCooldown = cooldown;
    }

    public boolean isInventoryOpen() {
        return this.isInventoryOpen;
    }

    public void setInventoryOpen(boolean open) {
        this.isInventoryOpen = open;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.fetchCooldown > 0) {
            --this.fetchCooldown;
        }
        if (this.m_21825_() && this.f_19797_ % 10 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + (double)this.m_20192_() + 0.25, this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), this.m_217043_().m_188500_(), 0.0, 0.0);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6084_()) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_150930_(Items.f_42656_)) {
                return InteractionResult.PASS;
            }
            if (this.m_21826_() == player) {
                if (player.m_6144_()) {
                    if (!this.m_9236_().m_5776_()) {
                        ItemStack luggageItem = this.convertToItem();
                        if (player.m_150109_().m_36054_(luggageItem)) {
                            this.m_146870_();
                            this.m_5496_(SoundEvents.f_12019_, 0.5f, this.m_217043_().m_188501_() * 0.1f + 0.9f);
                        }
                    }
                } else {
                    this.m_9236_().m_142346_((Entity)player, GameEvent.f_157803_, player.m_20183_());
                    if (this.getSoundCooldown() == 0) {
                        this.m_5496_(SoundEvents.f_11749_, 0.5f, this.m_217043_().m_188501_() * 0.1f + 0.9f);
                        this.setSoundCooldown(5);
                    }
                    if (!this.m_9236_().m_5776_()) {
                        ServerPlayer sp = (ServerPlayer)player;
                        if (sp.f_36096_ != sp.f_36095_) {
                            sp.m_6915_();
                        }
                        sp.m_9217_();
                        LuggageNetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new OpenLuggageScreenPacket(sp.f_8940_, this.m_19879_()));
                        sp.f_36096_ = new LuggageMenu(sp.f_8940_, sp.m_150109_(), (Container)this.inventory, this);
                        sp.m_143399_(sp.f_36096_);
                        this.isInventoryOpen = true;
                        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)sp, sp.f_36096_));
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            player.m_5661_((Component)Component.m_237115_((String)"entity.luggage.player_doesnt_own").m_130940_(ChatFormatting.DARK_RED), true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
        if (!this.hasExtendedInventory()) {
            this.setExtendedInventory(true);
        } else {
            super.m_8038_(level, lightningBolt);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED) {
            this.getInventory().m_19195_().forEach(arg_0 -> ((Luggage)this).m_19983_(arg_0));
            this.m_21373_();
            this.m_5496_((SoundEvent)Registries.SoundRegistry.LUGGAGE_KILLED.get(), 8.0f, 1.0f);
        }
        super.m_142687_(reason);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)Registries.ItemRegistry.LUGGAGE.get());
    }
}

