/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateAdapter
extends TypeAdapter<BlockState> {
    public BlockState read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return BlockStateAdapter.resolveBlockState(reader.nextString());
    }

    public void write(JsonWriter writer, BlockState blockState) throws IOException {
        if (blockState == null) {
            writer.nullValue();
            return;
        }
        String blockString = String.valueOf(blockState);
        if (blockString.startsWith("Block")) {
            blockString = blockString.replace("Block", "");
        }
        blockString = blockString.replace("{", "");
        blockString = blockString.replace("}", "");
        writer.value(blockString);
    }

    public static BlockState resolveBlockState(String fullString) {
        BlockState blockState;
        HashMap<String, String> properties = new HashMap<String, String>();
        String blockString = fullString;
        int startIndex = fullString.indexOf(91);
        int stopIndex = fullString.indexOf(93);
        if (startIndex != -1) {
            blockString = fullString.substring(0, startIndex);
            if (stopIndex < startIndex) {
                YungsApiCommon.LOGGER.error("JSON: Malformed property {}. Missing a bracket?", (Object)fullString);
                YungsApiCommon.LOGGER.error("Using air instead...");
                return Blocks.f_50016_.m_49966_();
            }
            String currKey = "";
            StringBuilder currString = new StringBuilder();
            for (int index = startIndex + 1; index <= stopIndex; ++index) {
                char currChar = fullString.charAt(index);
                if (currChar == '=') {
                    currKey = currString.toString();
                    currString = new StringBuilder();
                    continue;
                }
                if (currChar == ',' || currChar == ']') {
                    properties.put(currKey, currString.toString());
                    currString = new StringBuilder();
                    continue;
                }
                currString.append(fullString.charAt(index));
            }
        }
        try {
            blockState = ((Block)Registry.f_122824_.m_7745_(new ResourceLocation(blockString))).m_49966_();
        }
        catch (Exception e) {
            YungsApiCommon.LOGGER.error("JSON: Unable to read block '{}': {}", (Object)blockString, (Object)e.toString());
            YungsApiCommon.LOGGER.error("Using air instead...");
            return Blocks.f_50016_.m_49966_();
        }
        if (properties.size() > 0) {
            blockState = BlockStateAdapter.getConfiguredBlockState(blockState, properties);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState getConfiguredBlockState(BlockState blockState, Map<String, String> properties) {
        Block block = blockState.m_60734_();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean found = false;
            for (Property p : blockState.m_61147_()) {
                Property property = p;
                if (!property.m_61708_().equals(key)) continue;
                Comparable val = property.m_6215_(value).orElse(null);
                if (val == null) {
                    YungsApiCommon.LOGGER.error("JSON: Found null for property {} for block {}", (Object)property, (Object)Registry.f_122824_.m_7447_((Object)block));
                    continue;
                }
                blockState = (BlockState)blockState.m_61124_(property, val);
                found = true;
                break;
            }
            if (found) continue;
            YungsApiCommon.LOGGER.error("JSON: Unable to find property {} for block {}", (Object)key, (Object)Registry.f_122824_.m_7447_((Object)block));
        }
        return blockState;
    }
}

