/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.IMultiStateBlock;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.blockinformation.BlockInformation;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RemovalPatternPlacementType
extends AbstractCustomRegistryEntry
implements IPatternPlacementType {
    @Override
    public VoxelShape buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, Player player, Vec3 targetedPoint, Direction hitFace) {
        BlockPos targetedPosition = hitFace.m_122421_() == Direction.AxisDirection.NEGATIVE ? new BlockPos(targetedPoint) : new BlockPos(targetedPoint).m_121955_(hitFace.m_122424_().m_122436_());
        VoxelShape targetingShape = BlockPosStreamProvider.getForRange(player.m_6144_() ? targetedPoint : Vec3.m_82528_((Vec3i)targetedPosition), player.m_6144_() ? targetedPoint.m_82520_(0.9999, 0.9999, 0.9999) : Vec3.m_82528_((Vec3i)targetedPosition)).map(position -> player.f_19853_.m_8055_(position).m_60808_((BlockGetter)player.f_19853_, position).m_83216_((double)(position.m_123341_() - targetedPosition.m_123341_()), (double)(position.m_123342_() - targetedPosition.m_123342_()), (double)(position.m_123343_() - targetedPosition.m_123343_()))).reduce(Shapes.m_83040_(), (voxelShape, voxelShape2) -> Shapes.m_83148_((VoxelShape)voxelShape, (VoxelShape)voxelShape2, (BooleanOp)BooleanOp.f_82695_)).m_83296_();
        Vec3 offSet = player.m_6144_() ? new Vec3(targetedPoint.m_7096_() - (double)targetedPosition.m_123341_(), targetedPoint.m_7098_() - (double)targetedPosition.m_123342_(), targetedPoint.m_7094_() - (double)targetedPosition.m_123343_()) : Vec3.f_82478_;
        VoxelShape ownShape = ((IPatternPlacementType)ModPatternPlacementTypes.PLACEMENT.get()).buildVoxelShapeForWireframe(sourceSnapshot, player, targetedPoint, hitFace).m_83216_(offSet.m_7096_(), offSet.m_7098_(), offSet.m_7094_());
        return Shapes.m_83113_((VoxelShape)targetingShape, (VoxelShape)ownShape, (BooleanOp)BooleanOp.f_82685_);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, BlockPlaceContext context, boolean simulate) {
        boolean hasRequiredSpace;
        Vec3 targetedPosition = context.m_43723_().m_6144_() ? context.m_43720_() : Vec3.m_82528_((Vec3i)context.m_8083_().m_121955_(context.m_43719_().m_122424_().m_122436_()));
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((LevelAccessor)context.m_43725_(), targetedPosition, targetedPosition.m_82520_(0.9999, 0.9999, 0.9999));
        boolean isChiseledBlock = BlockPosStreamProvider.getForAccessor(areaMutator).map(pos -> context.m_43725_().m_8055_(pos)).allMatch(state -> state.m_60734_() instanceof IMultiStateBlock);
        if (isChiseledBlock) {
            return PlacementResult.failure(IClientConfiguration::getNotFittingPatternPlacementColor, (Component)LocalStrings.PatternPlacementNotASolidBlock.getText());
        }
        boolean isSupported = BlockPosStreamProvider.getForAccessor(areaMutator).map(pos -> {
            BlockState state = context.m_43725_().m_8055_(pos);
            BlockEntity blockEntity = context.m_43725_().m_7702_(pos);
            return new BlockInformation(state, IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(blockEntity)));
        }).allMatch(state -> IEligibilityManager.getInstance().canBeChiseled((IBlockInformation)state) || state.isAir());
        if (!isSupported) {
            return PlacementResult.failure(IClientConfiguration::getNotFittingPatternPlacementColor, (Component)LocalStrings.PatternPlacementNotASupportedBlock.getText());
        }
        Map<IBlockInformation, Integer> totalRemovedBits = source.stream().filter(s -> !s.getBlockInformation().isAir()).filter(s -> {
            Optional<IStateEntryInfo> o = areaMutator.getInAreaTarget(s.getStartPoint().m_82549_(areaMutator.getInWorldStartPoint()));
            return o.filter(os -> !os.getBlockInformation().isAir()).map(os -> !os.getBlockInformation().equals(s.getBlockInformation())).orElse(false);
        }).map(s -> areaMutator.getInAreaTarget(s.getStartPoint().m_82549_(areaMutator.getInWorldStartPoint()))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(IStateEntryInfo::getBlockInformation, s -> 1, Integer::sum));
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.m_43723_());
        boolean bl = hasRequiredSpace = context.m_43723_().m_7500_() || totalRemovedBits.entrySet().stream().allMatch(e -> playerBitInventory.canInsert((IBlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredSpace) {
            return PlacementResult.failure(IClientConfiguration::getMissingBitsOrSpacePatternPlacementColor, (Component)LocalStrings.PatternPlacementNoBitSpace.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.m_43723_()));){
            source.stream().filter(s -> !s.getBlockInformation().isAir()).forEach(stateEntryInfo -> areaMutator.clearInAreaTarget(stateEntryInfo.getStartPoint()));
        }
        if (!context.m_43723_().m_7500_()) {
            totalRemovedBits.forEach(playerBitInventory::insertOrDiscard);
        }
        return PlacementResult.success();
    }

    @Override
    public Vec3 getTargetedPosition(ItemStack heldStack, Player playerEntity, BlockHitResult blockRayTraceResult) {
        return Vec3.m_82528_((Vec3i)blockRayTraceResult.m_82425_());
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return new ResourceLocation("chiselsandbits", "textures/icons/pattern_remove.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public Component getDisplayName() {
        return LocalStrings.PatternPlacementModeRemoval.getText();
    }
}

