/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.client.screens.widgets.MultiStateSnapshotWidget;
import mod.chiselsandbits.container.ModificationTableContainer;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.recipe.modificationtable.ModificationTableRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class ModificationTableScreen
extends AbstractContainerScreen<ModificationTableContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("chiselsandbits", "textures/gui/container/modification_table.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;
    private MultiStateSnapshotWidget snapshotWidget;
    private int lastRenderedSelectedRecipeIndex = -1;

    public ModificationTableScreen(ModificationTableContainer containerIn, Inventory playerInv, Component titleIn) {
        super((AbstractContainerMenu)containerIn, playerInv, titleIn);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.f_97729_;
        this.f_97727_ = 197;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.snapshotWidget = (MultiStateSnapshotWidget)this.m_142416_(new MultiStateSnapshotWidget(this.f_97735_ + 51, this.f_97736_ + 71, 66, 28, (Component)Component.m_237115_((String)"chiselsandbits.screen.widgets.multistate.preview")));
    }

    public void m_6305_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(@NotNull PoseStack matrixStack, float partialTicks, int x, int y) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        int left = this.f_97735_;
        int top = this.f_97736_;
        this.m_93228_(matrixStack, left, top, 0, 0, this.f_97726_, this.f_97727_);
        int sliderOffset = (int)(41.0f * this.sliderProgress);
        this.m_93228_(matrixStack, left + 119, top + 15 + sliderOffset, this.f_97726_ + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int recipesLeft = this.f_97735_ + 52;
        int recipesTop = this.f_97736_ + 14;
        int recipeIndexOffsetMax = this.recipeIndexOffset + 12;
        this.renderButtons(matrixStack, x, y, recipesLeft, recipesTop, recipeIndexOffsetMax);
        this.drawRecipesItems(recipesLeft, recipesTop, recipeIndexOffsetMax);
        if (this.lastRenderedSelectedRecipeIndex != ((ModificationTableContainer)this.f_97732_).getSelectedRecipe() && this.hasItemsInInputSlot) {
            this.lastRenderedSelectedRecipeIndex = ((ModificationTableContainer)this.f_97732_).getSelectedRecipe();
            IMultiStateSnapshot snapshot = ((ModificationTableContainer)this.f_97732_).getRecipeList().get(this.lastRenderedSelectedRecipeIndex).getAppliedSnapshot(((ModificationTableContainer)this.f_97732_).inputInventory);
            this.snapshotWidget.setSnapshot(snapshot);
        }
    }

    protected void m_7025_(@NotNull PoseStack matrixStack, int x, int y) {
        super.m_7025_(matrixStack, x, y);
        if (this.hasItemsInInputSlot) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.recipeIndexOffset + 12;
            List<ModificationTableRecipe> list = ((ModificationTableContainer)this.f_97732_).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((ModificationTableContainer)this.f_97732_).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                this.m_96602_(matrixStack, list.get(l).getDisplayName(), x, y);
            }
        }
    }

    private void renderButtons(PoseStack matrixStack, int x, int y, int p_238853_4_, int p_238853_5_, int p_238853_6_) {
        for (int i = this.recipeIndexOffset; i < p_238853_6_ && i < ((ModificationTableContainer)this.f_97732_).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = p_238853_4_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_238853_5_ + l * 18 + 2;
            int j1 = this.f_97727_;
            if (i == ((ModificationTableContainer)this.f_97732_).getSelectedRecipe()) {
                j1 += 18;
            } else if (x >= k && y >= i1 && x < k + 16 && y < i1 + 18) {
                j1 += 36;
            }
            this.m_93228_(matrixStack, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(int recipesLeft, int recipesTop, int recipeIndexOffsetMax) {
        List<ModificationTableRecipe> list = ((ModificationTableContainer)this.f_97732_).getRecipeList();
        for (int offset = this.recipeIndexOffset; offset < recipeIndexOffsetMax && offset < ((ModificationTableContainer)this.f_97732_).getRecipeListSize(); ++offset) {
            int itemIndex = offset - this.recipeIndexOffset;
            int itemX = recipesLeft + itemIndex % 4 * 16;
            int rowIndex = itemIndex / 4;
            int itemY = recipesTop + rowIndex * 18 + 2;
            if (this.f_96541_ == null) continue;
            this.f_96541_.m_91291_().m_115203_(list.get(offset).getCraftingBlockResult(((ModificationTableContainer)this.f_97732_).inputInventory), itemX, itemY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.f_97735_ + 52;
            int j = this.f_97736_ + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (this.f_96541_ == null || this.f_96541_.f_91074_ == null || !(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((ModificationTableContainer)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                if (this.f_96541_.f_91072_ != null) {
                    this.f_96541_.f_91072_.m_105208_(((ModificationTableContainer)this.f_97732_).f_38840_, l);
                }
                return true;
            }
            i = this.f_97735_ + 119;
            j = this.f_97736_ + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnSroll && this.canScroll()) {
            int i = this.f_97736_ + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        if (this.snapshotWidget.m_5953_(mouseX, mouseY)) {
            return this.snapshotWidget.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.snapshotWidget.m_5953_(mouseX, mouseY)) {
            return this.snapshotWidget.m_6050_(mouseX, mouseY, delta);
        }
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((ModificationTableContainer)this.f_97732_).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((ModificationTableContainer)this.f_97732_).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((ModificationTableContainer)this.f_97732_).hasItemsInInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
            this.snapshotWidget.setSnapshot(EmptySnapshot.INSTANCE);
            this.lastRenderedSelectedRecipeIndex = -1;
        }
    }
}

