/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.client.font.GuiBagFontRenderer;
import mod.chiselsandbits.client.icon.IconManager;
import mod.chiselsandbits.client.screens.widgets.GuiIconButton;
import mod.chiselsandbits.client.util.GuiUtil;
import mod.chiselsandbits.container.BagContainer;
import mod.chiselsandbits.inventory.wrapping.WrappingInventory;
import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.network.packets.BagGuiPacket;
import mod.chiselsandbits.network.packets.ClearBagGuiPacket;
import mod.chiselsandbits.network.packets.SortBagGuiPacket;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BitBagScreen
extends AbstractContainerScreen<BagContainer> {
    private static final ResourceLocation BAG_GUI_TEXTURE = new ResourceLocation("chiselsandbits", "textures/gui/container/bitbag.png");
    private static GuiBagFontRenderer specialFontRenderer = null;
    boolean requireConfirm = true;
    boolean dontThrow = false;
    private GuiIconButton trashBtn;
    private Slot hoveredBitSlot = null;

    public BitBagScreen(BagContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97727_ = 239;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.trashBtn = (GuiIconButton)this.m_142416_(new GuiIconButton(this.f_97735_ - 20, this.f_97736_, IconManager.getInstance().getTrashIcon(), button -> {
            if (this.requireConfirm) {
                this.dontThrow = true;
                if (this.isValidBitItem()) {
                    this.requireConfirm = false;
                }
            } else {
                this.requireConfirm = true;
                ClearBagGuiPacket packet = new ClearBagGuiPacket(this.getInHandItem());
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(packet);
                packet.execute((Player)Minecraft.m_91087_().f_91074_);
            }
        }, (button, poseStack, mouseX, mouseY) -> {
            if (this.isValidBitItem()) {
                MutableComponent msgNotConfirm = !this.getInHandItem().m_41619_() ? LocalStrings.TrashItem.getText(this.getInHandItem().m_41786_().getString()) : LocalStrings.Trash.getText();
                MutableComponent msgConfirm = !this.getInHandItem().m_41619_() ? LocalStrings.ReallyTrashItem.getText(this.getInHandItem().m_41786_().getString()) : LocalStrings.ReallyTrash.getText();
                List<MutableComponent> text = Collections.singletonList(this.requireConfirm ? msgNotConfirm : msgConfirm);
                GuiUtil.drawHoveringText(poseStack, text, mouseX, mouseY, this.f_96543_, this.f_96544_, -1, Minecraft.m_91087_().f_91062_);
            } else {
                List<MutableComponent> text = Collections.singletonList(LocalStrings.TrashInvalidItem.getText(this.getInHandItem().m_41786_().getString()));
                GuiUtil.drawHoveringText(poseStack, text, mouseX, mouseY, this.f_96543_, this.f_96544_, -1, Minecraft.m_91087_().f_91062_);
            }
        }));
        this.m_142416_(new GuiIconButton(this.f_97735_ - 20, this.f_97736_ + 22, IconManager.getInstance().getSortIcon(), button -> {
            SortBagGuiPacket packet = new SortBagGuiPacket();
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(packet);
            packet.execute((Player)Minecraft.m_91087_().f_91074_);
        }, (button, poseStack, mouseX, mouseY) -> {
            List<MutableComponent> text = Collections.singletonList(LocalStrings.Sort.getText());
            GuiUtil.drawHoveringText(poseStack, text, mouseX, mouseY, this.f_96543_, this.f_96544_, -1, Minecraft.m_91087_().f_91062_);
        }));
    }

    BagContainer getBagContainer() {
        return (BagContainer)this.f_97732_;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean doThrow;
        boolean bl = doThrow = !this.dontThrow;
        if (this.requireConfirm && this.dontThrow) {
            this.dontThrow = false;
        }
        return doThrow && super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    public void m_6305_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void m_7286_(@NotNull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        int xOffset = (this.f_96543_ - this.f_97726_) / 2;
        int yOffset = (this.f_96544_ - this.f_97727_) / 2;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BAG_GUI_TEXTURE);
        this.m_93228_(stack, xOffset, yOffset, 0, 0, this.f_97726_, this.f_97727_);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        RenderSystem.m_157182_();
        if (specialFontRenderer == null) {
            specialFontRenderer = new GuiBagFontRenderer(this.f_96547_, IServerConfiguration.getInstance().getBagStackSize().get());
        }
        this.hoveredBitSlot = null;
        stack.m_85836_();
        for (int slotIdx = 0; slotIdx < this.getBagContainer().customSlots.size(); ++slotIdx) {
            Slot slot = this.getBagContainer().customSlots.get(slotIdx);
            Font defaultFontRenderer = this.f_96547_;
            try {
                this.f_96547_ = specialFontRenderer;
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                this.m_97799_(stack, slot);
            }
            finally {
                this.f_96547_ = defaultFontRenderer;
            }
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            int xDisplayPos = slot.f_40220_;
            int yDisplayPos = slot.f_40221_;
            this.hoveredBitSlot = slot;
            RenderSystem.m_69465_();
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int INNER_SLOT_SIZE = 16;
            this.m_93179_(stack, xDisplayPos, yDisplayPos, xDisplayPos + 16, yDisplayPos + 16, -2130706433, -2130706433);
            RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.m_69482_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
        stack.m_85849_();
        if (!this.trashBtn.m_5953_(mouseX, mouseY)) {
            this.requireConfirm = true;
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean duplicateButton = button == Minecraft.m_91087_().f_91066_.f_92097_.f_90816_.m_84873_() + 100;
        Slot slot = this.f_97734_;
        if (slot == null) {
            slot = this.hoveredBitSlot;
        }
        if (slot != null && slot.f_40218_ instanceof WrappingInventory && Minecraft.m_91087_().f_91074_ != null) {
            BagGuiPacket bagGuiPacket = new BagGuiPacket(slot.f_40219_, button, duplicateButton, Minecraft.m_91087_().m_91268_() != null && Screen.m_96638_());
            bagGuiPacket.doAction((Player)Minecraft.m_91087_().f_91074_);
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(bagGuiPacket);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private ItemStack getInHandItem() {
        return Minecraft.m_91087_().f_91074_ == null ? ItemStack.f_41583_ : Minecraft.m_91087_().f_91074_.f_36096_.m_142621_();
    }

    private boolean isValidBitItem() {
        return this.getInHandItem().m_41619_() || this.getInHandItem().m_41720_() == ModItems.ITEM_BLOCK_BIT.get();
    }

    protected void m_7027_(@NotNull PoseStack matrixStack, int x, int y) {
        this.f_96547_.m_92877_(matrixStack, Language.m_128107_().m_5536_((FormattedText)((BitBagItem)ModItems.ITEM_BIT_BAG_DEFAULT.get()).m_7626_(ItemStack.f_41583_)), 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.f_97727_ - 93), 0x404040);
    }
}

