/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.registry;

import alexthw.starbunclemania.registry.ModRegistry;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.NotNull;

public class SourceFluid
extends FluidType {
    public SourceFluid() {
        super(FluidType.Properties.create().supportsBoating(true).canHydrate(true).density(1).temperature(1).viscosity(1));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){
            private static final ResourceLocation STILL = new ResourceLocation("ars_nouveau", "blocks/potion_still");
            private static final ResourceLocation FLOW = new ResourceLocation("ars_nouveau", "blocks/potion_still");
            private static final ResourceLocation OVERLAY = new ResourceLocation("ars_nouveau", "blocks/sourcestone");
            private static final ResourceLocation VIEW_OVERLAY = new ResourceLocation("ars_nouveau", "textures/blocks/sourcestone.png");

            public ResourceLocation getStillTexture() {
                return STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return FLOW;
            }

            public ResourceLocation getOverlayTexture() {
                return OVERLAY;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return VIEW_OVERLAY;
            }

            public int getTintColor() {
                return -543484933;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                int color = this.getTintColor();
                return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                nearDistance = -8.0f;
                farDistance = 24.0f;
                if (farDistance > renderDistance) {
                    farDistance = renderDistance;
                    shape = FogShape.CYLINDER;
                }
                RenderSystem.m_157445_((float)nearDistance);
                RenderSystem.m_157443_((float)farDistance);
                RenderSystem.m_202160_((FogShape)shape);
            }
        });
    }

    public static class FluidTypeSourceClient {
        public FluidTypeSourceClient(IEventBus modEventBus) {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(this::registerBlockColors);
        }

        public void clientSetup(FMLClientSetupEvent ignoredEvent) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModRegistry.SOURCE_FLUID.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModRegistry.SOURCE_FLUID_FLOWING.get()), (RenderType)RenderType.m_110466_());
        }

        private void registerBlockColors(RegisterColorHandlersEvent.Block event) {
            event.register((state, getter, pos, index) -> {
                if (getter != null && pos != null) {
                    FluidState fluidState = getter.m_6425_(pos);
                    return IClientFluidTypeExtensions.of((FluidState)fluidState).getTintColor(fluidState, getter, pos);
                }
                return -1350565932;
            }, new Block[]{(Block)ModRegistry.SOURCE_FLUID_BLOCK.get()});
        }
    }
}

