/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.glyph;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.glyph.WrappedExtractedItemHandler;
import alexthw.starbunclemania.starbuncle.fluid.StarbyFluidBehavior;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

public class PlaceFluidEffect
extends AbstractEffect {
    public static final PlaceFluidEffect INSTANCE = new PlaceFluidEffect();

    public PlaceFluidEffect() {
        super(StarbuncleMania.prefix("glyph_place_fluid"), "Place Fluid");
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        this.onResolveBlock(new BlockHitResult(rayTraceResult.m_82450_(), Direction.UP, rayTraceResult.m_82443_().m_20097_(), true), world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        List posList = SpellUtil.calcAOEBlocks((LivingEntity)shooter, (BlockPos)rayTraceResult.m_82425_(), (BlockHitResult)rayTraceResult, (SpellStats)spellStats);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world));
        List<IFluidHandler> tanks = this.getTanks(world, spellContext);
        if (tanks.isEmpty()) {
            return;
        }
        for (BlockPos pos1 : posList) {
            if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), (Level)world, (BlockPos)pos1)) continue;
            BlockPos blockPos = pos1 = spellStats.getBuffCount((AbstractAugment)AugmentSensitive.INSTANCE) > 0 ? pos1 : pos1.m_121945_(rayTraceResult.m_82434_());
            if (world.m_7702_(pos1) != null && world.m_7702_(pos1).getCapability(ForgeCapabilities.FLUID_HANDLER, rayTraceResult.m_82434_()).isPresent()) {
                IFluidHandler cap = StarbyFluidBehavior.getHandlerFromCap(pos1, world, rayTraceResult.m_82434_().ordinal());
                this.placeInTank(cap, tanks);
                continue;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos1), world.m_8055_(pos1), (Entity)fakePlayer))) continue;
            this.place(pos1, world, shooter, tanks, spellContext, resolver, new BlockHitResult(new Vec3((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_()), rayTraceResult.m_82434_(), pos1, false));
        }
        for (IFluidHandler tank : tanks) {
            if (!(tank instanceof WrappedExtractedItemHandler)) continue;
            WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
            wrap.extractedStack.returnOrDrop(world, shooter.m_20097_());
        }
    }

    private void placeInTank(IFluidHandler cap, List<IFluidHandler> tanks) {
        for (IFluidHandler tank : tanks) {
            int room;
            FluidStack fluid = tank.getFluidInTank(0);
            if (fluid.isEmpty() || !cap.isFluidValid(0, fluid) || (room = Math.min(1000, cap.fill(fluid, IFluidHandler.FluidAction.SIMULATE))) <= 0) continue;
            int actualFill = cap.fill(new FluidStack(fluid, room), IFluidHandler.FluidAction.EXECUTE);
            tank.drain(actualFill, IFluidHandler.FluidAction.EXECUTE);
            if (!(tank instanceof WrappedExtractedItemHandler)) continue;
            WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
            wrap.updateContainer();
        }
    }

    private void place(BlockPos pPos, Level world, LivingEntity shooter, List<IFluidHandler> tanks, SpellContext spellContext, SpellResolver resolver, BlockHitResult resolveResult) {
        BlockState state = world.m_8055_(pPos);
        boolean isReplaceable = state.m_60767_().m_76336_();
        for (IFluidHandler tank : tanks) {
            LiquidBlockContainer container;
            FluidStack tester;
            Fluid fluid;
            if (tank.getFluidInTank(0).isEmpty() || !((fluid = (tester = new FluidStack(tank.getFluidInTank(0), 1000)).getFluid()) instanceof FlowingFluid)) continue;
            FlowingFluid ff = (FlowingFluid)fluid;
            if (tank.drain(tester, IFluidHandler.FluidAction.SIMULATE).getAmount() != 1000 || !state.m_60795_() && !isReplaceable && (!((fluid = state.m_60734_()) instanceof LiquidBlockContainer) || !(container = (LiquidBlockContainer)fluid).m_6044_((BlockGetter)world, pPos, state, (Fluid)ff))) continue;
            if (state.m_60819_().m_76170_() && state.m_60819_().getFluidType() == ff.getFluidType()) break;
            if (world.m_6042_().f_63857_() && tester.getFluid().m_205067_(FluidTags.f_13131_)) {
                int i = pPos.m_123341_();
                int j = pPos.m_123342_();
                int k = pPos.m_123343_();
                world.m_5594_(null, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else {
                LiquidBlockContainer container2;
                Block block = state.m_60734_();
                if (block instanceof LiquidBlockContainer && (container2 = (LiquidBlockContainer)block).m_6044_((BlockGetter)world, pPos, state, (Fluid)ff)) {
                    container2.m_7361_((LevelAccessor)world, pPos, state, ff.m_76145_());
                } else {
                    if (!world.f_46443_ && state.m_60767_().m_76336_() && !state.m_60767_().m_76332_()) {
                        world.m_46961_(pPos, true);
                    }
                    if (!world.m_7731_(pPos, ff.m_76145_().m_76188_(), 11) && !state.m_60819_().m_76170_()) continue;
                }
            }
            tank.drain(tester, IFluidHandler.FluidAction.EXECUTE);
            if (tank instanceof WrappedExtractedItemHandler) {
                WrappedExtractedItemHandler wrap = (WrappedExtractedItemHandler)tank;
                wrap.updateContainer();
            }
            ShapersFocus.tryPropagateBlockSpell((BlockHitResult)resolveResult, (Level)world, (LivingEntity)shooter, (SpellContext)spellContext, (SpellResolver)resolver);
            break;
        }
    }

    public List<IFluidHandler> getTanks(Level world, SpellContext spellContext) {
        ArrayList<IFluidHandler> handlers;
        block3: {
            TileCaster tile;
            block4: {
                handlers = new ArrayList<IFluidHandler>();
                IWrappedCaster iWrappedCaster = spellContext.getCaster();
                if (!(iWrappedCaster instanceof TileCaster)) break block3;
                tile = (TileCaster)iWrappedCaster;
                if (!((iWrappedCaster = tile.getTile()) instanceof RuneTile)) break block4;
                RuneTile rune = (RuneTile)iWrappedCaster;
                if (rune.isSensitive) break block3;
            }
            BlockPos tilePos = tile.getTile().m_58899_();
            for (Direction side : Direction.values()) {
                IFluidHandler handler;
                BlockPos pos = tilePos.m_121945_(side);
                BlockEntity be = world.m_7702_(pos);
                if (be == null || !be.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent() || (handler = StarbyFluidBehavior.getHandlerFromCap(pos, world, side.ordinal())) == null || handler.getFluidInTank(0).isEmpty() || handler.getFluidInTank(0).getAmount() < 1000) continue;
                handlers.add(handler);
            }
        }
        PlaceFluidEffect.getTankItems(spellContext, handlers);
        return handlers;
    }

    public static void getTankItems(SpellContext spellContext, List<IFluidHandler> handlers) {
        InventoryManager manager = spellContext.getCaster().getInvManager();
        Predicate<ItemStack> predicate = i -> !i.m_41619_() && i.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
        FilterableItemHandler highestHandler = manager.highestPrefInventory(manager.getInventory(), predicate, InteractType.EXTRACT);
        if (highestHandler != null) {
            for (SlotReference slot : PlaceFluidEffect.findItems(highestHandler, predicate, InteractType.EXTRACT)) {
                ExtractedStack extractItem = ExtractedStack.from((SlotReference)slot, (int)1);
                if (extractItem.isEmpty()) continue;
                handlers.add(new WrappedExtractedItemHandler((IFluidHandlerItem)extractItem.stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().get(), extractItem));
            }
        }
    }

    public static List<SlotReference> findItems(FilterableItemHandler itemHandler, Predicate<ItemStack> stackPredicate, InteractType type) {
        ArrayList<SlotReference> slots = new ArrayList<SlotReference>();
        for (int slot = 0; slot < Inventory.m_36059_(); ++slot) {
            ItemStack stackInSlot = itemHandler.getHandler().getStackInSlot(slot);
            if (stackInSlot.m_41619_() || !stackPredicate.test(stackInSlot) || !itemHandler.canInteractFor(stackInSlot, type).valid()) continue;
            slots.add(new SlotReference(itemHandler.getHandler(), slot));
        }
        return slots;
    }

    public int getDefaultManaCost() {
        return 20;
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION, SpellSchools.ELEMENTAL_WATER});
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentSensitive.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE});
    }
}

