/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.crafting;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import gripe._90.megacells.crafting.DecompressionPatternEncoding;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DecompressionPattern
implements IPatternDetails {
    private final AEItemKey definition;
    private final AEItemKey base;
    private final AEItemKey variant;
    private final int factor;
    private final boolean toCompress;

    public DecompressionPattern(ItemStack stack) {
        this(Objects.requireNonNull(AEItemKey.of((ItemStack)stack)));
    }

    public DecompressionPattern(AEItemKey definition) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.base = DecompressionPatternEncoding.getBase(tag);
        this.variant = DecompressionPatternEncoding.getVariant(tag);
        this.factor = DecompressionPatternEncoding.getFactor(tag);
        this.toCompress = DecompressionPatternEncoding.getToCompress(tag);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return new IPatternDetails.IInput[]{this.toCompress ? new Input(this.base, this.factor) : new Input(this.variant, 1L)};
    }

    public GenericStack[] getOutputs() {
        return new GenericStack[]{this.toCompress ? new GenericStack((AEKey)this.variant, 1L) : new GenericStack((AEKey)this.base, (long)this.factor)};
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((DecompressionPattern)obj).definition.equals((Object)this.definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    private record Input(AEItemKey input, long multiplier) implements IPatternDetails.IInput
    {
        public GenericStack[] getPossibleInputs() {
            return new GenericStack[]{new GenericStack((AEKey)this.input, 1L)};
        }

        public long getMultiplier() {
            return this.multiplier;
        }

        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.getPossibleInputs()[0]);
        }

        public AEKey getRemainingKey(AEKey template) {
            return null;
        }
    }
}

