/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.template;

import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.util.exceptions.TemplateParseException;
import com.direwolf20.buildinggadgets.common.util.tools.JsonBiDiSerializer;
import com.google.common.base.Preconditions;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.maven.artifact.versioning.ComparableVersion;

public final class TemplateHeader {
    public static final String VERSION = "2.1.0";
    public static final String HIGHEST_MC_VERSION = "1.17.1";
    public static final String LOWEST_MC_VERSION = "1.14.4";
    private static final ComparableVersion COMP_VERSION = new ComparableVersion("2.1.0");
    private static final ComparableVersion HIGHEST_MC_COMP = new ComparableVersion("1.17.1");
    private static final ComparableVersion LOWEST_MC_COMP = new ComparableVersion("1.14.4");
    private static final JsonBiDiSerializer<TemplateHeader> BI_DI_SERIALIZER = new JsonBiDiSerializer<TemplateHeader>(){

        public TemplateHeader deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject data = json.getAsJsonObject();
            String mcVersion = data.getAsJsonPrimitive("mc_version").getAsString();
            ComparableVersion templateMcVersion = new ComparableVersion(mcVersion);
            if (templateMcVersion.compareTo(LOWEST_MC_COMP) < 0 || templateMcVersion.compareTo(HIGHEST_MC_COMP) > 0) {
                throw new TemplateParseException.IllegalMinecraftVersionException(mcVersion);
            }
            String version = data.getAsJsonPrimitive("version").getAsString();
            if (new ComparableVersion(version).compareTo(COMP_VERSION) > 0) {
                throw new TemplateParseException.UnknownTemplateVersionException(version);
            }
            Builder builder = data.has("bounding_box") ? TemplateHeader.builder((Region)context.deserialize(data.get("bounding_box"), Region.class)) : TemplateHeader.builder(Region.singleZero());
            if (data.has("name")) {
                builder.name((String)context.deserialize(data.get("name"), String.class));
            }
            if (data.has("author")) {
                builder.author((String)context.deserialize(data.get("author"), String.class));
            }
            if (data.has("material_list")) {
                builder.requiredItems((MaterialList)context.deserialize(data.get("material_list"), MaterialList.class));
            }
            return builder.build();
        }

        public JsonElement serialize(TemplateHeader src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("version", TemplateHeader.VERSION);
            object.addProperty("mc_version", TemplateHeader.HIGHEST_MC_VERSION);
            if (src.getName() != null) {
                object.addProperty("name", src.getName());
            }
            if (src.getAuthor() != null) {
                object.addProperty("author", src.getAuthor());
            }
            object.add("bounding_box", context.serialize((Object)src.getBoundingBox(), Region.class));
            if (src.getRequiredItems() != null) {
                object.add("material_list", context.serialize((Object)src.getRequiredItems(), MaterialList.class));
            }
            return object;
        }
    };
    @Nullable
    private final String name;
    @Nullable
    private final String author;
    @Nonnull
    private final Region boundingBox;
    @Nullable
    private final MaterialList requiredItems;

    public static Builder builder(Region boundingBox) {
        return new Builder(boundingBox);
    }

    public static Builder builderOf(TemplateHeader header) {
        return TemplateHeader.builderOf(header, header.getBoundingBox());
    }

    public static Builder builderOf(TemplateHeader header, Region boundingBox) {
        return TemplateHeader.builder(boundingBox).author(header.getAuthor()).name(header.getName()).requiredItems(header.getRequiredItems());
    }

    public static Builder builderFromNBT(CompoundTag nbt, boolean persisted) {
        Preconditions.checkArgument((boolean)nbt.m_128425_("bounds", 10), (Object)"Cannot construct a TemplateHeader without 'bounds'!");
        Region region = Region.deserializeFrom(nbt.m_128469_("bounds"));
        Builder builder = TemplateHeader.builder(region);
        if (nbt.m_128425_("name", 8)) {
            builder.name(nbt.m_128461_("name"));
        }
        if (nbt.m_128425_("author", 8)) {
            builder.author(nbt.m_128461_("author"));
        }
        if (nbt.m_128425_("materials", 10)) {
            builder.requiredItems(MaterialList.deserialize(nbt.m_128469_("materials"), persisted));
        }
        return builder;
    }

    public static Builder builderFromNBT(CompoundTag nbt) {
        return TemplateHeader.builderFromNBT(nbt, true);
    }

    public static TemplateHeader fromNBT(CompoundTag nbt) {
        return TemplateHeader.builderFromNBT(nbt).build();
    }

    public static GsonBuilder appendHeaderSpecification(GsonBuilder builder, boolean printName, boolean extended) {
        return builder.setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(ResourceLocation.class, (Object)new JsonBiDiSerializer<ResourceLocation>(){

            public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new ResourceLocation(json.getAsJsonPrimitive().getAsString());
            }

            public JsonElement serialize(ResourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        }).registerTypeAdapter(MaterialList.class, (Object)new MaterialList.JsonSerializer(printName, extended)).registerTypeAdapter(TemplateHeader.class, BI_DI_SERIALIZER);
    }

    private TemplateHeader(@Nullable String name, @Nullable String author, @Nullable MaterialList requiredItems, @Nonnull Region boundingBox) {
        this.name = name;
        this.author = author;
        this.requiredItems = requiredItems;
        this.boundingBox = Objects.requireNonNull(boundingBox);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public MaterialList getRequiredItems() {
        return this.requiredItems;
    }

    public Region getBoundingBox() {
        return this.boundingBox;
    }

    public CompoundTag toNBT(boolean persisted) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("bounds", (Tag)this.getBoundingBox().serialize());
        if (this.getName() != null) {
            nbt.m_128359_("name", this.getName());
        }
        if (this.getAuthor() != null) {
            nbt.m_128359_("author", this.getAuthor());
        }
        if (!persisted && this.getRequiredItems() != null) {
            nbt.m_128365_("materials", (Tag)this.getRequiredItems().serialize(persisted));
        }
        return nbt;
    }

    public String toJson(boolean printName, boolean extended) {
        return TemplateHeader.appendHeaderSpecification(new GsonBuilder(), printName, extended).create().toJson((Object)this);
    }

    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private String author;
        @Nullable
        private MaterialList requiredItems;
        @Nonnull
        private Region boundingBox;

        private Builder(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
        }

        public Builder bounds(Region boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox);
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder author(@Nullable String author) {
            this.author = author;
            return this;
        }

        public Builder requiredItems(@Nullable MaterialList requiredItems) {
            this.requiredItems = requiredItems;
            return this;
        }

        public TemplateHeader build() {
            return new TemplateHeader(this.name, this.author, this.requiredItems, this.boundingBox);
        }
    }
}

